/*
 
 Copyright (C) 2009 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import java.io.Serializable;

public abstract class NotifyTypeMstInfo implements Serializable {
	private static String _dtoVersion = "1";
	
	public String getDtoVerion(){
		return _dtoVersion;
	}
	
	/**
	 * 通知種別を返します。
	 * @return 通知種別
	 */
	abstract public Integer getNotifyType();
	
	/**
	 * 通知種別表示用メッセージのキーを返します。
	 * @return 通知種別表示用メッセージのキー
	 */
	abstract public java.lang.String getNotifyNameKey();

	/**
	 * ダイアログクラスを返します。
	 * @return ダイアログクラス
	 */
	abstract public java.lang.String getDialogClassName();
}
