/*
 
Copyright (C) since 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.bean;

import java.io.Serializable;
import java.util.List;

/**
 * HinemosのRole(権限)の情報一覧を格納するクラス<BR>
 * DTOクラスとしてマネージャ、クライアント間の通信で利用する
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserRoleList implements Serializable {
	/** Roleリスト */
	private final List<String> m_roles;
	
	/** ReadRoleリスト */
	public final List<String> m_readRoles;

	/** WriteRoleリスト */
	public final List<String> m_writeRoles;
	
	/** ExecRoleリスト */
	public final List<String> m_execRoles;
	
	public UserRoleList(List<String> allRoles, List<String> readRoles, List<String> writeRoles, List<String> execRoles){
		m_roles = allRoles;
		m_readRoles = readRoles;
		m_writeRoles = writeRoles;
		m_execRoles = execRoles;
	}
	
	/**
	 * 権限名の配列を返します。
	 * 
	 * @return 権限名の配列
	 */
	public List<String> getRoles() {
		return m_roles;
	}
	
	/**
	 * 読み込み権限名の配列を返します。
	 * 
	 * @return 読み込み権限名の配列
	 */
	public List<String> getReadRoles() {
		return m_readRoles;
	}

	/**
	 * 書き込み権限名の配列を返します。
	 * 
	 * @return 書き込み権限名の配列
	 */
	public List<String> getWriteRoles() {
		return m_writeRoles;
	}

	/**
	 * 実行権限名の配列を返します。
	 * 
	 * @return 実行権限名の配列
	 */
	public List<String> getExecRoles() {
		return m_execRoles;
	}
}
