/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import org.jboss.logging.Logger;
import org.jboss.remoting.serialization.ClassLoaderUtility;

public class RemotingClassLoader
extends ClassLoader {
    private ClassLoader secondaryClassLoader = null;
    private boolean useCurrentThreadClassLoader;
    protected static final Logger log = Logger.getLogger(RemotingClassLoader.class);
    protected static final boolean isTrace = log.isTraceEnabled();

    public RemotingClassLoader(ClassLoader primaryClassLoader, ClassLoader secondaryClassLoader) {
        super(primaryClassLoader);
        this.secondaryClassLoader = secondaryClassLoader;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class loadedClass;
        block8: {
            loadedClass = null;
            try {
                loadedClass = Class.forName(name, false, this.getParent());
                if (isTrace) {
                    log.trace((Object)("loaded from primary classloader: " + name));
                }
            }
            catch (ClassNotFoundException e) {
                if (isTrace) {
                    log.trace((Object)("Could not load class (" + name + ") using parent remoting class loader (" + this.getParent() + ")"));
                }
                if (this.secondaryClassLoader == null) break block8;
                try {
                    loadedClass = Class.forName(name, false, this.secondaryClassLoader);
                    if (isTrace) {
                        log.trace((Object)("loaded from secondary classloader: " + name));
                    }
                }
                catch (ClassNotFoundException e1) {
                    if (!isTrace) break block8;
                    log.trace((Object)("Could not load class (" + name + ") using parent remoting class loader (" + this.getParent() + ")"));
                }
            }
        }
        if (loadedClass == null) {
            loadedClass = ClassLoaderUtility.loadClass(name, this.getClass());
        }
        return loadedClass;
    }

    public String toString() {
        return "RemotingClassLoader[" + System.identityHashCode(this) + ":" + this.getParent() + "]";
    }

    public boolean isUseCurrentThreadClassLoader() {
        return this.useCurrentThreadClassLoader;
    }

    public void setUseCurrentThreadClassLoader(boolean useCurrentThreadClassLoader) {
        this.useCurrentThreadClassLoader = useCurrentThreadClassLoader;
    }
}

