/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.LeasePinger;
import org.jboss.remoting.MicroRemoteClientInvoker;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.util.StoppableTimerTask;
import org.jboss.remoting.util.TimerUtil;

public class ConnectionValidator
extends TimerTask
implements StoppableTimerTask {
    private static final Logger log = Logger.getLogger((String)ConnectionValidator.class.getName());
    public static final String VALIDATOR_PING_PERIOD = "validatorPingPeriod";
    public static final long DEFAULT_PING_PERIOD = 2000L;
    public static final String VALIDATOR_PING_TIMEOUT = "validatorPingTimeout";
    public static final String DEFAULT_PING_TIMEOUT = "1000";
    public static final int DEFAULT_PING_TIMEOUT_INT = 1000;
    public static final String DEFAULT_NUMBER_OF_PING_RETRIES = "1";
    public static final String TIE_TO_LEASE = "tieToLease";
    public static final String STOP_LEASE_ON_FAILURE = "stopLeaseOnFailure";
    public static final String FAILURE_DISCONNECT_TIMEOUT = "failureDisconnectTimeout";
    private static boolean trace = log.isTraceEnabled();
    private Client client;
    private long pingPeriod;
    private Map metadata;
    private InvokerLocator locator;
    private Map configMap;
    private Map listeners;
    private ClientInvoker clientInvoker;
    private Object lock = new Object();
    private Object notificationLock = new Object();
    private boolean started;
    private volatile boolean stopped;
    private volatile boolean stopping;
    private String invokerSessionId;
    private boolean tieToLease = true;
    private boolean stopLeaseOnFailure = true;
    private int pingTimeout;
    private int failureDisconnectTimeout = -1;
    private volatile boolean isValid;
    private Timer timer;
    private MicroRemoteClientInvoker sharedInvoker;
    private LeasePinger leasePinger;
    private boolean useClientConnectionIdentity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnection(InvokerLocator locator, Map config) throws Throwable {
        boolean pingWorked = false;
        Map configMap = ConnectionValidator.createPingConfig(config, null);
        int pingTimeout = Integer.parseInt((String)configMap.get("timeout"));
        ClientInvoker innerClientInvoker = null;
        try {
            innerClientInvoker = InvokerRegistry.createClientInvoker(locator, configMap);
            if (!innerClientInvoker.isConnected()) {
                if (trace) {
                    log.trace((Object)"inner client invoker not connected, connecting ...");
                }
                innerClientInvoker.connect();
            }
            pingWorked = ConnectionValidator.doCheckConnection(innerClientInvoker, pingTimeout);
        }
        catch (Throwable throwable) {
            log.debug((Object)("ConnectionValidator unable to connect to server " + innerClientInvoker.getLocator().getProtocol() + "://" + innerClientInvoker.getLocator().getHost() + ":" + innerClientInvoker.getLocator().getPort()), throwable);
        }
        finally {
            if (innerClientInvoker != null) {
                InvokerRegistry.destroyClientInvoker(locator, configMap);
            }
        }
        return pingWorked;
    }

    private static boolean doCheckConnection(ClientInvoker clientInvoker, int pingTimeout) throws Throwable {
        boolean pingWorked = false;
        try {
            InvocationRequest ir = new InvocationRequest(null, "self", "$PING$", null, null, null);
            ConnectionCheckThread t = new ConnectionCheckThread(clientInvoker, ir);
            t.start();
            Thread.sleep(pingTimeout);
            pingWorked = t.isValid();
        }
        catch (Throwable t) {
            log.debug((Object)("ConnectionValidator failed to ping via " + clientInvoker), t);
        }
        return pingWorked;
    }

    private static Map createPingConfig(Map config, Map metadata) {
        Object o;
        HashMap<String, String> localConfig = new HashMap<String, String>();
        localConfig.put("connection_checker", "true");
        if (config != null) {
            o = config.get(VALIDATOR_PING_TIMEOUT);
            log.trace((Object)("config timeout: " + o));
            if (o != null) {
                try {
                    Integer.parseInt((String)o);
                    localConfig.put("timeout", (String)o);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Need integer for value of parameter validatorPingTimeout. Using default value 1000");
                }
            }
            if ((o = config.get("NumberOfCallRetries")) != null) {
                localConfig.put("NumberOfCallRetries", (String)o);
            }
        }
        if (metadata != null) {
            metadata.remove("timeout");
            localConfig.putAll(metadata);
            o = metadata.get(VALIDATOR_PING_TIMEOUT);
            if (o != null) {
                try {
                    Integer.parseInt((String)o);
                    localConfig.put("timeout", (String)o);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Need integer for value of parameter validatorPingTimeout. Using default value 1000");
                }
            }
        }
        if (localConfig.get("timeout") == null) {
            localConfig.put("timeout", DEFAULT_PING_TIMEOUT);
        }
        if (localConfig.get("NumberOfCallRetries") == null) {
            localConfig.put("NumberOfCallRetries", DEFAULT_NUMBER_OF_PING_RETRIES);
        }
        return localConfig;
    }

    public ConnectionValidator(Client client) {
        this(client, 2000L);
    }

    public ConnectionValidator(Client client, long pingPeriod) {
        this.client = client;
        this.locator = client.getInvoker().getLocator();
        this.pingPeriod = pingPeriod;
        this.pingTimeout = 1000;
        this.listeners = new HashMap();
        this.stopped = false;
        this.getParameters(client, new HashMap());
        log.debug((Object)(this + " created"));
    }

    public ConnectionValidator(Client client, Map metadata) {
        this.client = client;
        this.locator = client.getInvoker().getLocator();
        this.pingPeriod = 2000L;
        this.pingTimeout = 1000;
        this.listeners = new HashMap();
        this.stopped = false;
        this.metadata = new HashMap(metadata);
        this.getParameters(client, metadata);
        log.debug((Object)(this + " created"));
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException(ConnectionValidator.class.getName() + ".run() should not be " + "called directly; use " + ConnectionValidator.class.getName() + ".addConnectionListener() instead.");
            }
            if (this.stopping) {
                return;
            }
            WaitOnConnectionCheckTimerTask tt = new WaitOnConnectionCheckTimerTask();
            try {
                this.timer.schedule((TimerTask)tt, 0L);
            }
            catch (IllegalStateException e) {
                log.debug((Object)"Unable to schedule TimerTask on existing Timer", (Throwable)e);
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)tt, 0L);
            }
        }
        try {
            if (!this.stopping) {
                this.isValid = false;
                if (this.tieToLease && this.client.getLeasePeriod() > 0L) {
                    if (trace) {
                        log.trace((Object)(this + " sending PING tied to lease"));
                    }
                    this.isValid = this.doCheckConnectionWithLease();
                } else {
                    if (trace) {
                        log.trace((Object)(this + " pinging ..."));
                    }
                    this.isValid = this.doCheckConnectionWithoutLease();
                }
            }
        }
        catch (Throwable thr) {
            log.debug((Object)(this + " got throwable while pinging"), thr);
            if (this.stopLeaseOnFailure) {
                log.debug((Object)(this + " detected connection failure: stopping"));
                this.cancel();
            }
        }
        finally {
            object = this.notificationLock;
            synchronized (object) {
                this.notificationLock.notifyAll();
            }
        }
    }

    public boolean cancel() {
        return this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnectionListener(Client client, ConnectionListener listener) {
        boolean doStart = false;
        if (listener != null) {
            Object object = this.lock;
            synchronized (object) {
                HashSet<Client> s;
                if (this.stopping) {
                    if (trace) {
                        log.trace((Object)(this + " is stopped. Cannot add ConnectionListener: " + listener + " for " + client));
                    }
                    return false;
                }
                if (this.listeners.size() == 0) {
                    doStart = true;
                }
                if ((s = (HashSet<Client>)this.listeners.get(listener)) == null) {
                    s = new HashSet<Client>();
                }
                s.add(client);
                this.listeners.put(listener, s);
                log.debug((Object)(this + " added ConnectionListener: " + listener + " for " + client));
            }
            if (doStart) {
                this.start();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnectionListener(Client client, ConnectionListener listener) {
        if (listener == null) {
            if (trace) {
                log.trace((Object)(this + " ConnectionListener is null"));
            }
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.stopping) {
                if (trace) {
                    log.trace((Object)(this + " is stopped. It's too late to remove " + listener));
                }
                return false;
            }
            Set s = (Set)this.listeners.get(listener);
            if (s == null) {
                log.debug((Object)(this + ": " + listener + " is not registered"));
                return false;
            }
            if (!s.remove(client)) {
                log.debug((Object)(this + ": " + listener + " is not registered for " + client));
                return false;
            }
            log.debug((Object)(this + " removed ConnectionListener: " + listener + " for " + client));
            if (s.size() == 0) {
                this.listeners.remove(listener);
            }
            if (this.listeners.size() == 0) {
                this.stop();
            }
        }
        return true;
    }

    public long getPingPeriod() {
        if (this.stopping) {
            return -1L;
        }
        return this.pingPeriod;
    }

    public String toString() {
        return "ConnectionValidator[" + Integer.toHexString(System.identityHashCode(this)) + ":" + this.clientInvoker + ", pingPeriod=" + this.pingPeriod + " ms]";
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(Throwable thr) {
        final Throwable t = thr;
        Object object = this.lock;
        synchronized (object) {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
            if (trace) {
                log.trace((Object)(this + " is stopped.  No more listeners will be accepted."));
            }
            for (final ConnectionListener listener : this.listeners.keySet()) {
                Set clients = (Set)this.listeners.get(listener);
                for (final Client client : clients) {
                    new Thread(){

                        public void run() {
                            log.debug((Object)(ConnectionValidator.this + " calling " + listener + ".handleConnectionException() for " + client));
                            listener.handleConnectionException(t, client);
                        }
                    }.start();
                }
            }
            this.listeners.clear();
        }
        this.stop();
    }

    private void getParameters(Client client, Map metadata) {
        if (this.checkUseParametersFromLocator(client, metadata)) {
            this.getParametersFromMap(client.getInvoker().getLocator().getParameters());
        }
        this.getParametersFromMap(client.getConfiguration());
        this.getParametersFromMap(metadata);
        ClientInvoker clientInvoker = client.getInvoker();
        if (!(clientInvoker instanceof MicroRemoteClientInvoker)) {
            throw new RuntimeException("creating a ConnectionValidator on a local connection");
        }
        this.sharedInvoker = (MicroRemoteClientInvoker)clientInvoker;
        this.invokerSessionId = this.sharedInvoker.getSessionId();
        if (this.stopLeaseOnFailure && this.sharedInvoker != null) {
            this.leasePinger = this.sharedInvoker.getLeasePinger();
        }
        if (trace) {
            log.trace((Object)(this + ": sharedInvoker = " + this.sharedInvoker + ", leasePinger = " + this.leasePinger));
        }
    }

    private boolean checkUseParametersFromLocator(Client client, Map metadata) {
        if (client.getInvoker() == null) {
            return false;
        }
        Object o = client.getInvoker().getLocator().getParameters().get("useAllParams");
        if (o != null) {
            if (o instanceof String) {
                return Boolean.valueOf((String)o);
            }
            log.warn((Object)(this + " could not convert " + "useAllParams" + " value" + " in InvokerLocator to a boolean: must be a String"));
        }
        if (client.getConfiguration() != null && (o = client.getConfiguration().get("useAllParams")) != null) {
            if (o instanceof String) {
                return Boolean.valueOf((String)o);
            }
            log.warn((Object)(this + " could not convert " + "useAllParams" + " value" + " in Client configuration map to a boolean: must be a String"));
        }
        if (metadata != null && (o = metadata.get("useAllParams")) != null) {
            if (o instanceof String) {
                return Boolean.valueOf((String)o);
            }
            log.warn((Object)(this + " could not convert " + "useAllParams" + " value" + " in metadata map to a boolean: must be a String"));
        }
        return false;
    }

    private void getParametersFromMap(Map config) {
        if (config != null) {
            ClientInvoker invoker;
            Object o = config.get(VALIDATOR_PING_PERIOD);
            if (o != null) {
                if (o instanceof String) {
                    try {
                        this.pingPeriod = Long.parseLong((String)o);
                    }
                    catch (Exception e) {
                        log.warn((Object)(this + " could not convert " + VALIDATOR_PING_PERIOD + " value of " + o + " to a long value"));
                    }
                } else {
                    log.warn((Object)(this + " could not convert " + VALIDATOR_PING_PERIOD + " value of " + o + " to a long value: must be a String"));
                }
            }
            if ((o = config.get(VALIDATOR_PING_TIMEOUT)) != null) {
                if (o instanceof String) {
                    try {
                        this.pingTimeout = Integer.parseInt((String)o);
                    }
                    catch (Exception e) {
                        log.warn((Object)(this + " could not convert " + VALIDATOR_PING_TIMEOUT + " value of " + o + " to a long value"));
                    }
                } else {
                    log.warn((Object)(this + " could not convert " + VALIDATOR_PING_TIMEOUT + " value of " + o + " to a long value: must be a String"));
                }
            }
            if ((o = config.get(TIE_TO_LEASE)) != null) {
                if (o instanceof String) {
                    try {
                        this.tieToLease = Boolean.valueOf((String)o);
                    }
                    catch (Exception e) {
                        log.warn((Object)(this + " could not convert " + TIE_TO_LEASE + " value" + " to a boolean: " + o));
                    }
                } else {
                    log.warn((Object)(this + " could not convert " + TIE_TO_LEASE + " value" + " to a boolean: must be a String"));
                }
            }
            if ((o = config.get(STOP_LEASE_ON_FAILURE)) != null) {
                if (o instanceof String) {
                    try {
                        this.stopLeaseOnFailure = Boolean.valueOf((String)o);
                    }
                    catch (Exception e) {
                        log.warn((Object)(this + " could not convert " + STOP_LEASE_ON_FAILURE + " value" + " to a boolean: " + o));
                    }
                } else {
                    log.warn((Object)(this + " could not convert " + STOP_LEASE_ON_FAILURE + " value" + " to a boolean: must be a String"));
                }
            }
            if ((invoker = this.client.getInvoker()) == null) {
                if (trace) {
                    log.trace((Object)(this + " client invoker == null"));
                }
            } else if (trace) {
                log.trace((Object)(this + " InvokerLocator: " + invoker.getLocator()));
            }
            o = config.get(FAILURE_DISCONNECT_TIMEOUT);
            if (trace) {
                log.trace((Object)(this + " \"failureDisconnectTimeout\" set to " + o));
            }
            if (o != null) {
                if (o instanceof String) {
                    try {
                        this.failureDisconnectTimeout = Integer.valueOf((String)o);
                        if (trace) {
                            log.trace((Object)(this + " setting failureDisconnectTimeout to " + this.failureDisconnectTimeout));
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)(this + " could not convert " + FAILURE_DISCONNECT_TIMEOUT + " value" + " to an int: " + o));
                    }
                } else {
                    log.warn((Object)(this + " could not convert " + FAILURE_DISCONNECT_TIMEOUT + " value" + " to an int: must be a String"));
                }
            }
            if ((o = config.get("useClientConnectionIdentity")) != null) {
                if (o instanceof String) {
                    try {
                        this.useClientConnectionIdentity = Boolean.valueOf((String)o);
                    }
                    catch (Exception e) {
                        log.warn((Object)(this + " could not convert " + "useClientConnectionIdentity" + " value" + " to a boolean: " + o));
                    }
                } else {
                    log.warn((Object)(this + " could not convert " + "useClientConnectionIdentity" + " value" + " to a boolean: must be a String"));
                }
            }
        }
    }

    private void start() {
        this.metadata.put("timeout", Integer.toString(this.pingTimeout));
        this.configMap = ConnectionValidator.createPingConfig(this.client.getConfiguration(), this.metadata);
        log.debug((Object)(this + ": pingPeriod:  " + this.pingPeriod));
        log.debug((Object)(this + ": pingTimeout: " + this.pingTimeout));
        log.debug((Object)(this + ": ping retries: " + this.configMap.get("NumberOfCallRetries")));
        this.locator = this.client.getInvoker().getLocator();
        try {
            this.clientInvoker = InvokerRegistry.createClientInvoker(this.locator, this.configMap);
        }
        catch (Exception e) {
            log.debug((Object)("Unable to create client invoker for locator: " + this.locator));
            throw new RuntimeException("Unable to create client invoker for locator: " + this.locator, e);
        }
        if (!this.clientInvoker.isConnected()) {
            if (trace) {
                log.trace((Object)"inner client invoker not connected, connecting ...");
            }
            this.clientInvoker.connect();
        }
        this.started = true;
        this.timer = new Timer(true);
        try {
            TimerUtil.schedule(this, this.pingPeriod);
        }
        catch (Exception e) {
            log.error((Object)(this + " unable to schedule on TimerUtil"), (Throwable)e);
            this.started = false;
            this.timer = null;
            return;
        }
        log.debug((Object)(this + " started"));
    }

    private boolean doCheckConnectionWithLease() throws Throwable {
        boolean pingWorked = false;
        try {
            Object o;
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("invokerSessionId", this.invokerSessionId);
            InvocationRequest ir = new InvocationRequest(null, "self", "$PING$", metadata, null, null);
            if (trace) {
                log.trace((Object)("pinging, sending " + ir + " over " + this.clientInvoker));
            }
            if ((o = this.clientInvoker.invoke(ir)) instanceof Boolean && !((Boolean)o).booleanValue()) {
                throw new Exception("server indicates lease has stopped");
            }
            if (trace) {
                log.trace((Object)("ConnectionValidator got successful ping using " + this.clientInvoker));
            }
            pingWorked = true;
        }
        catch (Throwable t) {
            log.debug((Object)("ConnectionValidator failed to ping via " + this.clientInvoker), t);
        }
        return pingWorked;
    }

    private boolean doCheckConnectionWithoutLease() throws Throwable {
        boolean pingWorked = false;
        try {
            InvocationRequest ir = new InvocationRequest(null, "self", "$PING$", null, null, null);
            if (trace) {
                log.trace((Object)("pinging, sending " + ir + " over " + this.clientInvoker));
            }
            this.clientInvoker.invoke(ir);
            if (trace) {
                log.trace((Object)("ConnectionValidator got successful ping using " + this.clientInvoker));
            }
            pingWorked = true;
        }
        catch (Throwable t) {
            log.debug((Object)("ConnectionValidator failed to ping via " + this.clientInvoker), t);
        }
        return pingWorked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStop() {
        if (trace) {
            log.trace((Object)"entering doStop()");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.stopped) {
                return false;
            }
            if (!this.listeners.isEmpty()) {
                this.listeners.clear();
            }
            this.stopping = true;
            this.stopped = true;
            this.timer = null;
        }
        if (this.clientInvoker != null) {
            InvokerRegistry.destroyClientInvoker(this.locator, this.configMap);
        }
        TimerUtil.unschedule(this);
        boolean result = super.cancel();
        log.debug((Object)(this + " stopped, returning " + result));
        return result;
    }

    private static class ConnectionCheckThread
    extends Thread {
        private InvocationRequest ir;
        private ClientInvoker clientInvoker;
        private boolean isValid;

        public ConnectionCheckThread(ClientInvoker clientInvoker, InvocationRequest ir) {
            this.clientInvoker = clientInvoker;
            this.ir = ir;
            this.setDaemon(true);
        }

        public void run() {
            try {
                if (trace) {
                    log.trace((Object)("pinging, sending " + this.ir + " over " + this.clientInvoker));
                }
                this.clientInvoker.invoke(this.ir);
                this.isValid = true;
                if (trace) {
                    log.trace((Object)("ConnectionValidator got successful ping using " + this.clientInvoker));
                }
            }
            catch (Throwable t) {
                log.debug((Object)("ConnectionValidator failed to ping via " + this.clientInvoker), t);
            }
        }

        public boolean isValid() {
            return this.isValid;
        }
    }

    private class WaitOnConnectionCheckTimerTask
    extends TimerTask {
        private WaitOnConnectionCheckTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long start = System.currentTimeMillis();
            Object object = ConnectionValidator.this.notificationLock;
            synchronized (object) {
                while (true) {
                    int elapsed = (int)(System.currentTimeMillis() - start);
                    int wait = ConnectionValidator.this.pingTimeout - elapsed;
                    if (wait <= 0) break;
                    try {
                        ConnectionValidator.this.notificationLock.wait(wait);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            if (!ConnectionValidator.this.isValid) {
                log.debug((Object)(ConnectionValidator.this + "'s connection is invalid"));
                ConnectionValidator.super.cancel();
                if (ConnectionValidator.this.stopLeaseOnFailure) {
                    if (trace) {
                        log.trace((Object)(ConnectionValidator.this + " detected connection failure: stopping LeasePinger"));
                    }
                    if (ConnectionValidator.this.leasePinger != null) {
                        int disconnectTimeout;
                        log.debug((Object)(ConnectionValidator.this + " shutting down lease pinger: " + ConnectionValidator.this.leasePinger));
                        int n = disconnectTimeout = ConnectionValidator.this.failureDisconnectTimeout == -1 ? ConnectionValidator.this.client.getDisconnectTimeout() : ConnectionValidator.this.failureDisconnectTimeout;
                        if (trace) {
                            log.trace((Object)(ConnectionValidator.this + " disconnectTimeout: " + disconnectTimeout));
                        }
                        ConnectionValidator.this.sharedInvoker.terminateLease(null, disconnectTimeout, ConnectionValidator.this.leasePinger);
                    } else {
                        if (trace) {
                            log.trace((Object)(ConnectionValidator.this + ": lease pinger == null: perhaps leasing is not enabled for this connection"));
                        }
                        ConnectionValidator.this.notifyListeners(new Exception("Could not connect to server!"));
                    }
                    this.cancel();
                }
                if (!ConnectionValidator.this.useClientConnectionIdentity) {
                    ConnectionValidator.this.notifyListeners(new Exception("Could not connect to server!"));
                }
            }
        }
    }
}

