/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.OpenConnectionChecker;

public class ClientSocketWrapper
extends org.jboss.remoting.transport.socket.ClientSocketWrapper
implements OpenConnectionChecker {
    private static final Logger log = Logger.getLogger(ClientSocketWrapper.class);
    protected static final int CLOSING = 254;

    public ClientSocketWrapper(Socket socket) throws IOException {
        super(socket);
        this.createStreams(socket, null);
    }

    public ClientSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception {
        super(socket, metadata, timeout);
        this.createStreams(socket, metadata);
    }

    public void checkConnection() throws IOException {
        boolean ACK = true;
        log.debug((Object)(this + ".checkConnection() writing ACK"));
        ((DataOutputStream)this.getOutputStream()).writeByte(1);
        ((DataOutputStream)this.getOutputStream()).flush();
        try {
            byte b = ((DataInputStream)this.getInputStream()).readByte();
            log.debug((Object)(this + ".checkConnection read " + b));
        }
        catch (IOException e) {
            log.debug((Object)(this + ".checkConnection(): "), (Throwable)e);
            throw e;
        }
    }

    public void checkOpenConnection() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"checking open connection");
        }
        if (((DataInputStream)this.getInputStream()).available() > 0) {
            log.trace((Object)"remote endpoint has closed");
            throw new IOException("remote endpoint has closed");
        }
    }

    protected InputStream createInputStream(String serializationType, Socket socket, UnMarshaller unmarshaller) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(socket.getInputStream(), 65536);
        return new DataInputStream(bin);
    }

    protected OutputStream createOutputStream(String serializationType, Socket socket, Marshaller marshaller) throws IOException {
        OutputStream os = super.createOutputStream(serializationType, socket, marshaller);
        log.debug((Object)(this + ": os = " + os));
        BufferedOutputStream bout = new BufferedOutputStream(os, 65536);
        return new DataOutputStream(bout);
    }

    public String toString() {
        Socket socket = this.getSocket();
        return "NEW ClientSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
    }
}

