#!/bin/bash
#
#Copyright (C) since 2009 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

# bash configuration
. /opt/hinemos/hinemos.cfg
umask 377

########################################
# Definition
########################################
DB_USER=hinemos
DB_NAME=hinemos
DB_PORT=24001
DB_HOST=localhost

LDAP_BIND_DN="cn=Manager,dc=hinemos,dc=com"
LDAP_SEARCH_BASE="dc=hinemos,dc=com"
LDAP_PORT=24000
LDAP_HOST=localhost

DUMP_PATH="."
PGDUMP_FILE_BASE="hinemos_pgdump"
LDIF_FILE_BASE="hinemos_ldif"

DATE=`date "+%Y-%m-%d_%H%M%S"`
REV=0


########################################
#  Local Message
########################################

# INFO
MSG_I001="Getting a dump of a PostgreSQL database."
MSG_I002="Getting a dump of a OpenLDAP database."
MSG_I003="Start to get a dump of a PostgreSQL database..."
MSG_I004="Start to get a dump of a OpenLDAP database..."
MSG_I005="Done."

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="Failed."


########################################
# Function
########################################
function usage {
        echo "usage:"
	echo "hinemos_mng_online_backup.sh -p [password] : "$MSG_I001
	echo "hinemos_mng_online_backup.sh -l [password] : "$MSG_I002
	return 0
}

########################################
# Parameter Check
########################################

if [ $# -ne 1 -a $# -ne 2 ]; then
	usage
	exit 1
fi

if [ $1 = "-p" ]; then
	if [ $# = 2 ]; then
		export PGPASSWORD="$2"
	fi
elif [ $1 = "-l" ]; then
	if [ $# = 2 ]; then
		LDAPPASS="-w $2"
	else
		LDAPPASS="-W"
	fi
else
	usage
	exit 1
fi

########################################
# Main
########################################

if [ $1 = "-p" ]; then
	## pg_dump
	echo ${MSG_I003}
	DUMP_FILE=${DUMP_PATH}"/"${PGDUMP_FILE_BASE}"."${DATE}
	echo "dump file name : "${DUMP_FILE}
	if [ -e ${DUMP_FILE} ]; then
		echo "file "${DUMP_FILE}" already exists. please remove it at first,and try again." 
		exit 1
	fi
	${PG}/bin/pg_dump -U ${DB_USER} -p ${DB_PORT} -h ${DB_HOST} ${DB_NAME} -f ${DUMP_FILE} -C
	REV=$?
elif [ $1 = "-l" ]; then
	## ldapsearch
	echo ${MSG_I004}
	DUMP_FILE=${DUMP_PATH}"/"${LDIF_FILE_BASE}"."${DATE}
	echo "dump file name : "${DUMP_FILE}
	if [ -e ${DUMP_FILE} ]; then
		echo "file "${DUMP_FILE}" already exists. please remove it at first,and try again." 
		exit 1
	fi
	${LDAP}/bin/ldapsearch -h ${LDAP_HOST} -p ${LDAP_PORT} -LLL -D ${LDAP_BIND_DN} -x ${LDAPPASS} -b ${LDAP_SEARCH_BASE} > ${DUMP_FILE}
	REV=$?
else
	usage
	exit 1
fi

if [ ${REV} -ne 0 ]; then
	if [ -e ${DUMP_FILE} ]; then
		rm -f ${DUMP_FILE}
	fi
		echo ${MSG_E001}
	exit ${REV}
fi

########################################
# Termination Processing
########################################

echo ${MSG_I005}

exit 0 
