/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.ws.resources.ConfigurationMessages;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.util.ForkEntityResolver;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.api.XJC;
import com.sun.tools.xjc.reader.Util;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsimportOptions
extends Options {
    public String wsdlLocation;
    public EntityResolver entityResolver = null;
    public String defaultPackage = null;
    private SchemaCompiler schemaCompiler = XJC.createSchemaCompiler();
    private JCodeModel codeModel;
    public boolean noAddressingBbinding;
    private final List<InputSource> wsdls = new ArrayList<InputSource>();
    private final List<InputSource> schemas = new ArrayList<InputSource>();
    private final List<InputSource> bindingFiles = new ArrayList<InputSource>();
    private final List<InputSource> jaxwsCustomBindings = new ArrayList<InputSource>();
    private final List<InputSource> jaxbCustomBindings = new ArrayList<InputSource>();
    private final List<Element> handlerConfigs = new ArrayList<Element>();

    public JCodeModel getCodeModel() {
        if (this.codeModel == null) {
            this.codeModel = new JCodeModel();
        }
        return this.codeModel;
    }

    public SchemaCompiler getSchemaCompiler() {
        this.schemaCompiler.setTargetVersion(SpecVersion.parse(this.target.getVersion()));
        this.schemaCompiler.setEntityResolver(this.entityResolver);
        return this.schemaCompiler;
    }

    public void setCodeModel(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    @Override
    public int parseArguments(String[] args, int i) throws BadCommandLineException {
        int j = super.parseArguments(args, i);
        if (j > 0) {
            return j;
        }
        if (args[i].equals("-b")) {
            this.addBindings(this.requireArgument("-b", args, ++i));
            return 2;
        }
        if (args[i].equals("-wsdllocation")) {
            this.wsdlLocation = this.requireArgument("-wsdllocation", args, ++i);
            return 2;
        }
        if (args[i].equals("-p")) {
            this.defaultPackage = this.requireArgument("-p", args, ++i);
            return 2;
        }
        if (args[i].equals("-catalog")) {
            String catalog = this.requireArgument("-catalog", args, ++i);
            try {
                if (this.entityResolver == null) {
                    if (catalog != null && catalog.length() > 0) {
                        this.entityResolver = XmlUtil.createEntityResolver(JAXWSUtils.getFileOrURL(JAXWSUtils.absolutize(Util.escapeSpace(catalog))));
                    }
                } else if (catalog != null && catalog.length() > 0) {
                    EntityResolver er = XmlUtil.createEntityResolver(JAXWSUtils.getFileOrURL(JAXWSUtils.absolutize(Util.escapeSpace(catalog))));
                    this.entityResolver = new ForkEntityResolver(er, this.entityResolver);
                }
            }
            catch (IOException e) {
                throw new BadCommandLineException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(catalog, e.getMessage()));
            }
            return 2;
        }
        if (args[i].startsWith("-httpproxy:")) {
            String value = args[i].substring(11);
            if (value.length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(args[i]));
            }
            int index = value.indexOf(58);
            if (index == -1) {
                System.setProperty("proxySet", "true");
                System.setProperty("proxyHost", value);
                System.setProperty("proxyPort", "8080");
            } else {
                System.setProperty("proxySet", "true");
                System.setProperty("proxyHost", value.substring(0, index));
                System.setProperty("proxyPort", value.substring(index + 1));
            }
            return 1;
        }
        if (args[i].equals("-Xno-addressing-databinding")) {
            this.noAddressingBbinding = true;
            return 1;
        }
        if (args[i].startsWith("-B")) {
            String[] subCmd = new String[args.length - i];
            System.arraycopy(args, i, subCmd, 0, subCmd.length);
            subCmd[0] = subCmd[0].substring(2);
            com.sun.tools.xjc.Options jaxbOptions = this.schemaCompiler.getOptions();
            try {
                int r = jaxbOptions.parseArgument(subCmd, 0);
                if (r == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSIMPORT_NO_SUCH_JAXB_OPTION(subCmd[0]));
                }
                return r;
            }
            catch (com.sun.tools.xjc.BadCommandLineException e) {
                throw new BadCommandLineException(e.getMessage(), e);
            }
        }
        return 0;
    }

    public void validate() throws BadCommandLineException {
        if (this.wsdls.isEmpty()) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_MISSING_FILE());
        }
        if (this.wsdlLocation == null) {
            this.wsdlLocation = this.wsdls.get(0).getSystemId();
        }
    }

    @Override
    protected void addFile(String arg) throws BadCommandLineException {
        this.addFile(arg, this.wsdls, "*.wsdl");
    }

    public Element getHandlerChainConfiguration() {
        if (this.handlerConfigs.size() > 0) {
            return this.handlerConfigs.get(0);
        }
        return null;
    }

    public void addHandlerChainConfiguration(Element config) {
        this.handlerConfigs.add(config);
    }

    public InputSource[] getWSDLs() {
        return this.wsdls.toArray(new InputSource[this.wsdls.size()]);
    }

    public InputSource[] getSchemas() {
        return this.schemas.toArray(new InputSource[this.schemas.size()]);
    }

    public InputSource[] getWSDLBindings() {
        return this.jaxwsCustomBindings.toArray(new InputSource[this.jaxwsCustomBindings.size()]);
    }

    public InputSource[] getSchemaBindings() {
        return this.jaxbCustomBindings.toArray(new InputSource[this.jaxbCustomBindings.size()]);
    }

    public void addWSDL(File source) {
        this.addWSDL(this.fileToInputSource(source));
    }

    public void addWSDL(InputSource is) {
        this.wsdls.add(this.absolutize(is));
    }

    public void addSchema(File source) {
        this.addSchema(this.fileToInputSource(source));
    }

    public void addSchema(InputSource is) {
        this.schemas.add(is);
    }

    private InputSource fileToInputSource(File source) {
        try {
            String url = source.toURL().toExternalForm();
            return new InputSource(Util.escapeSpace(url));
        }
        catch (MalformedURLException e) {
            return new InputSource(source.getPath());
        }
    }

    public void addGrammarRecursive(File dir) {
        this.addRecursive(dir, ".wsdl", this.wsdls);
        this.addRecursive(dir, ".xsd", this.schemas);
    }

    public void addWSDLBindFile(InputSource is) {
        this.jaxwsCustomBindings.add(this.absolutize(is));
    }

    public void addSchemmaBindFile(InputSource is) {
        this.jaxbCustomBindings.add(this.absolutize(is));
    }

    private void addRecursive(File dir, String suffix, List<InputSource> result) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.addRecursive(f, suffix, result);
                continue;
            }
            if (!f.getPath().endsWith(suffix)) continue;
            result.add(this.absolutize(this.fileToInputSource(f)));
        }
    }

    private InputSource absolutize(InputSource is) {
        try {
            URL baseURL = new File(".").getCanonicalFile().toURL();
            is.setSystemId(new URL(baseURL, is.getSystemId()).toExternalForm());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    public void addBindings(String name) throws BadCommandLineException {
        this.addFile(name, this.bindingFiles, null);
    }

    private void addFile(String name, List<InputSource> target, String suffix) throws BadCommandLineException {
        Object src;
        try {
            src = Util.getFileOrURL(name);
        }
        catch (IOException e) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_NOT_A_FILE_NOR_URL(name));
        }
        if (src instanceof URL) {
            target.add(this.absolutize(new InputSource(Util.escapeSpace(((URL)src).toExternalForm()))));
        } else {
            File fsrc = (File)src;
            if (fsrc.isDirectory()) {
                this.addRecursive(fsrc, suffix, target);
            } else {
                target.add(this.absolutize(this.fileToInputSource(fsrc)));
            }
        }
    }

    public final void parseBindings(ErrorReceiver receiver) {
        for (InputSource is : this.bindingFiles) {
            XMLStreamReader reader = XMLStreamReaderFactory.create(is, true);
            XMLStreamReaderUtil.nextElementContent(reader);
            if (reader.getName().equals(JAXWSBindingsConstants.JAXWS_BINDINGS)) {
                this.jaxwsCustomBindings.add(is);
                continue;
            }
            if (reader.getName().equals(JAXWSBindingsConstants.JAXB_BINDINGS) || reader.getName().equals(new QName("http://www.w3.org/2001/XMLSchema", "schema"))) {
                this.jaxbCustomBindings.add(is);
                continue;
            }
            LocatorImpl locator = new LocatorImpl();
            locator.setSystemId(reader.getLocation().getSystemId());
            locator.setPublicId(reader.getLocation().getPublicId());
            locator.setLineNumber(reader.getLocation().getLineNumber());
            locator.setColumnNumber(reader.getLocation().getColumnNumber());
            receiver.warning(locator, ConfigurationMessages.CONFIGURATION_NOT_BINDING_FILE(is.getSystemId()));
        }
    }
}

