/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.common;

import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.ws.Constants;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerFactory;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;

public abstract class EventingEndpointBase {
    private AddressingBuilder addrBuilder;

    protected static AddressingProperties getAddrProperties() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        AddressingProperties inProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
        EventingEndpointBase.assertAddrProperties(inProps);
        return inProps;
    }

    protected SubscriptionManagerMBean getSubscriptionManager() {
        SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
        SubscriptionManagerMBean subscriptionManager = factory.getSubscriptionManager();
        return subscriptionManager;
    }

    protected AddressingBuilder getAddrBuilder() {
        if (null == this.addrBuilder) {
            this.addrBuilder = AddressingBuilder.getAddressingBuilder();
        }
        return this.addrBuilder;
    }

    protected static void assertAddrProperties(AddressingProperties inProps) throws SOAPFaultException {
        if (null == inProps) {
            throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "Addressing headers missing from request", "wse:InvalidMessage", null);
        }
        if (null == inProps.getTo()) {
            throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "Event source URI missing from request (wsa:To)", "wse:InvalidMessage", null);
        }
    }

    public QName buildFaultQName(String elementName) {
        return new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", elementName, "wse");
    }
}

