/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.DetailEntryImpl;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPFaultElementImpl;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DetailImpl
extends SOAPFaultElementImpl
implements Detail {
    private static Logger log = Logger.getLogger(DetailImpl.class);

    public DetailImpl() {
        super("detail");
    }

    public DetailImpl(String prefix, String namespace) {
        super("Detail", prefix, namespace);
    }

    DetailImpl(SOAPElementImpl element) {
        super(element.getElementName());
        DOMUtils.copyAttributes((Element)((Object)this), (Element)((Object)element));
        try {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node instanceof SOAPElement) {
                    this.addChildElement((SOAPElement)node);
                    continue;
                }
                this.appendChild(node);
            }
        }
        catch (SOAPException e) {
            throw new WSException("Unable to create fault detail", e);
        }
    }

    public DetailEntry addDetailEntry(Name name) throws SOAPException {
        DetailEntryImpl detailEntry = new DetailEntryImpl(name);
        this.addChildElement(detailEntry);
        return detailEntry;
    }

    public DetailEntry addDetailEntry(QName qname) throws SOAPException {
        DetailEntryImpl detailEntry = new DetailEntryImpl(qname);
        this.addChildElement(detailEntry);
        return detailEntry;
    }

    public Iterator getDetailEntries() {
        ArrayList<DetailEntry> list = new ArrayList<DetailEntry>();
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof DetailEntry)) continue;
            list.add((DetailEntry)node);
        }
        return list.iterator();
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        if (!(child instanceof DetailEntry)) {
            child = DetailImpl.convertToDetailEntry((SOAPElementImpl)child);
        }
        return super.addChildElement(child);
    }

    private static DetailEntry convertToDetailEntry(SOAPElementImpl element) {
        element.detachNode();
        DetailEntryImpl detailEntry = new DetailEntryImpl((SOAPElement)element);
        log.trace((Object)("convertToDetailEntry : " + detailEntry));
        return detailEntry;
    }
}

