/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.util;

import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstUtil;
import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollingDataManager {
    protected static Log m_log = LogFactory.getLog(PollingDataManager.class);
    private String m_platformId = "";
    private String m_subPlatformId = "";

    public PollingDataManager(String facilityId) {
        try {
            RepositoryControllerLocal repositoryLocal = RepositoryControllerUtil.getLocalHome().create();
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("ccPlatform");
            attributeList.add("ccVirtualizationSolution");
            HashMap facilityAttrMap = repositoryLocal.getNodeDetail(facilityId, attributeList);
            this.m_platformId = (String)facilityAttrMap.get("ccPlatform");
            this.m_subPlatformId = (String)facilityAttrMap.get("ccVirtualizationSolution");
            if (this.m_subPlatformId == null) {
                this.m_subPlatformId = "";
            }
        }
        catch (CreateException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getCollectMethod() {
        String collectMethod = "";
        try {
            m_log.debug((Object)("getColledtMethod() m_platformId : " + this.m_platformId + ", m_subPlatformId : " + this.m_subPlatformId));
            MonitorProcessMethodMstPK processPk = new MonitorProcessMethodMstPK(this.m_platformId, this.m_subPlatformId);
            MonitorProcessMethodMstLocal processLocal = MonitorProcessMethodMstUtil.getLocalHome().findByPrimaryKey(processPk);
            collectMethod = processLocal.getCollectMethod();
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return collectMethod;
    }

    public List<String> getPollingTargets(String collectMethod) {
        ArrayList<String> pollingTargets = new ArrayList<String>();
        try {
            Collection pollingBeans = MonitorProcessPollingMstUtil.getLocalHome().findByCollectMethodAndPlatformIdAndSubPlatformId(collectMethod, this.m_platformId, this.m_subPlatformId);
            Iterator itr = pollingBeans.iterator();
            while (itr.hasNext()) {
                m_log.debug((Object)("getPollingTargets() collectMethod : " + collectMethod + ", m_platformId : " + this.m_platformId + ", m_subPlatformId : " + this.m_subPlatformId));
                pollingTargets.add(((MonitorProcessPollingMstLocal)itr.next()).getPollingTarget());
            }
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return pollingTargets;
    }

    public String getPlatformId() {
        return this.m_platformId;
    }

    public String getSubPlatformId() {
        return this.m_subPlatformId;
    }
}

