/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.process.factory;

import com.clustercontrol.poller.CollectorAlreadyExistException;
import com.clustercontrol.poller.FacilityNotFoundException;
import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.poller.PollerManager;
import com.clustercontrol.poller.PollingController;
import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessMethodMstUtil;
import com.clustercontrol.process.util.PollingDataManager;
import com.clustercontrol.process.util.PollingProcConnectionManager;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import com.clustercontrol.sharedtable.SharedTable;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyPollingSchedule {
    protected static Log m_log = LogFactory.getLog(ModifyPollingSchedule.class);
    private static final HashMap<String, String> platformMethodMap = new HashMap();

    public boolean addSchedule(String monitorTypeId, String monitorId, String parentFacilityId, int interval) {
        if (parentFacilityId != null && !"".equals(parentFacilityId)) {
            try {
                SharedTable sst = PollingProcConnectionManager.getSharedTable();
                RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
                ArrayList facilityList = repository.getExecTargetFacilityIdList(parentFacilityId);
                String facilityId = null;
                for (int index = 0; index < facilityList.size(); ++index) {
                    facilityId = (String)facilityList.get(index);
                    if (facilityId == null || "".equals(facilityId)) continue;
                    if (!sst.containsTable(monitorTypeId, facilityId, 1)) {
                        sst.createDataTable(monitorTypeId, facilityId, 1);
                    }
                    InitialContext ctx = new InitialContext();
                    Object obj = ctx.lookup("PollerManager");
                    PollerManager manager = (PollerManager)PortableRemoteObject.narrow((Object)obj, PollerManager.class);
                    try {
                        PollingController poller = manager.getPoller(monitorTypeId, facilityId);
                        if (poller == null) {
                            poller = manager.createPoller(monitorTypeId, facilityId, true, monitorTypeId, facilityId);
                        }
                        PollingDataManager dataManager = new PollingDataManager(facilityId);
                        String collectMethod = dataManager.getCollectMethod();
                        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                        map.put(collectMethod, dataManager.getPollingTargets(collectMethod));
                        poller.startPolling(monitorId, interval, map);
                        continue;
                    }
                    catch (NotInitializedException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (DataTableNotFoundException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (CollectorAlreadyExistException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    catch (FacilityNotFoundException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return true;
            }
            catch (CreateException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
            catch (FinderException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
            catch (NamingException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
        }
        return false;
    }

    public boolean deleteSchedule(String monitorTypeId, String monitorId, String parentFacilityId) {
        if (parentFacilityId != null && !"".equals(parentFacilityId)) {
            try {
                SharedTable sst = PollingProcConnectionManager.getSharedTable();
                RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
                ArrayList facilityList = repository.getNodeFacilityIdList(parentFacilityId, 0);
                if (facilityList.size() == 0 && repository.isNode(parentFacilityId)) {
                    facilityList.add(parentFacilityId);
                }
                String facilityId = null;
                for (int index = 0; index < facilityList.size(); ++index) {
                    facilityId = (String)facilityList.get(index);
                    InitialContext ctx = new InitialContext();
                    Object obj = ctx.lookup("PollerManager");
                    PollerManager manager = (PollerManager)PortableRemoteObject.narrow((Object)obj, PollerManager.class);
                    PollingController poller = manager.getPoller(monitorTypeId, facilityId);
                    if (poller != null) {
                        poller.stopPolling(monitorId);
                    }
                    obj = ctx.lookup("SharedTable");
                    SharedTable sharedTable = (SharedTable)PortableRemoteObject.narrow((Object)obj, SharedTable.class);
                    try {
                        sharedTable.unregisterCollector(monitorTypeId, facilityId, monitorId);
                        continue;
                    }
                    catch (DataTableNotFoundException e) {
                        m_log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return true;
            }
            catch (CreateException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
            catch (FinderException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
            catch (NamingException e) {
                AplLogger apllog = new AplLogger("PROC", "proc");
                Object[] args = new String[]{parentFacilityId};
                apllog.put("SYS", "001", args);
                m_log.debug((Object)("addSchedule():" + e.getMessage()));
            }
        }
        return false;
    }

    static {
        try {
            Collection processMethod = MonitorProcessMethodMstUtil.getLocalHome().findAll();
            Iterator itr = processMethod.iterator();
            MonitorProcessMethodMstLocal local = null;
            while (itr.hasNext()) {
                local = (MonitorProcessMethodMstLocal)itr.next();
                platformMethodMap.put(local.getPlatformId(), local.getCollectMethod());
            }
        }
        catch (FinderException e) {
            m_log.warn((Object)"InternalError", (Throwable)e);
        }
        catch (NamingException e) {
            m_log.warn((Object)"InternalError", (Throwable)e);
        }
    }
}

