/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentState;

public class SerializableDeploymentInfo
implements Serializable {
    private static final long serialVersionUID = -3847995513551913798L;
    public Date date;
    public URL url;
    public URL localUrl;
    public URL watch;
    public String shortName;
    public long lastDeployed;
    public long lastModified;
    public String status;
    public DeploymentState state;
    public ObjectName deployer;
    public Collection classpath = new ArrayList();
    public List mbeans;
    public List subDeployments;
    public SerializableDeploymentInfo parent;
    public String webContext;
    public URL documentUrl;
    public boolean isXML;
    public boolean isScript;
    public boolean isDirectory;
    public ObjectName deployedObject;

    public SerializableDeploymentInfo(DeploymentInfo info) {
        this.date = info.date;
        this.url = info.url;
        this.localUrl = info.localUrl;
        this.watch = info.watch;
        this.shortName = info.shortName;
        this.lastDeployed = info.lastDeployed;
        this.lastModified = info.lastModified;
        this.status = info.status;
        this.state = info.state;
        this.deployer = info.deployer.getServiceName();
        this.classpath = info.classpath;
        this.mbeans = info.mbeans;
        this.webContext = info.webContext;
        this.documentUrl = info.documentUrl;
        this.isXML = info.isXML;
        this.isScript = info.isScript;
        this.isDirectory = info.isDirectory;
        this.deployedObject = info.deployedObject;
        this.parent = null;
        this.subDeployments = new ArrayList();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(" { url=" + this.url + " }\n");
        s.append("  deployer: " + this.deployer + "\n");
        s.append("  status: " + this.status + "\n");
        s.append("  state: " + this.state + "\n");
        s.append("  watch: " + this.watch + "\n");
        s.append("  lastDeployed: " + this.lastDeployed + "\n");
        s.append("  lastModified: " + this.lastModified + "\n");
        s.append("  mbeans: " + this.mbeans + "\n");
        s.append(" }\n");
        return s.toString();
    }
}

