/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;

public class SystemClassLoader
extends ClassLoader {
    private static final int NOT_INSTALLED = 0;
    private static final int INSTALLED = 1;
    private static final int INITIALIZING = 2;
    private static final int INITIALIZED = 3;
    private int state = 0;
    ClassLoader parent = null;
    Method deployXML;
    Method transform;
    Method instance;
    Object aspectManager;

    public SystemClassLoader(ClassLoader parent) {
        super(parent);
        this.install();
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.loadClassByDelegation(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        this.initialize();
        try {
            byte[] origBytes = this.loadClassBytes(name);
            byte[] classBytes = null;
            if (this.state == 3) {
                Object[] args = new Object[]{this, name, null, null, origBytes};
                classBytes = (byte[])this.transform.invoke(this.aspectManager, args);
            }
            if (classBytes == null) {
                classBytes = origBytes;
            }
            return this.defineClassFromBytes(name, classBytes, resolve);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("Unable to load " + name, ioe);
        }
        catch (IllegalAccessException iae) {
            throw new InternalError(iae.toString());
        }
        catch (InvocationTargetException ite) {
            throw new Error("Error transforming the class " + name + ": " + ite.getCause());
        }
    }

    protected byte[] loadClassBytes(String name) throws ClassNotFoundException, IOException {
        String classFileName = name.replace('.', '/') + ".class";
        InputStream in = this.getParent().getResourceAsStream(classFileName);
        if (in == null) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            File aopdynclasses = new File(tmpdir, "aopdynclasses");
            File classFile = new File(aopdynclasses, classFileName);
            try {
                in = new FileInputStream(classFile);
            }
            catch (FileNotFoundException fnfe) {
                throw new ClassNotFoundException(name + "(" + classFile.getPath() + ")", fnfe);
            }
        }
        byte[][] bufs = new byte[8][];
        int bufsize = 4096;
        for (int i = 0; i < 8; ++i) {
            bufs[i] = new byte[bufsize];
            int size = 0;
            int len = 0;
            do {
                if ((len = in.read(bufs[i], size, bufsize - size)) >= 0) continue;
                byte[] result = new byte[bufsize - 4096 + size];
                int s = 0;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(bufs[j], 0, result, s, s + 4096);
                    s = s + s + 4096;
                }
                System.arraycopy(bufs[i], 0, result, s, size);
                return result;
            } while ((size += len) < bufsize);
            bufsize *= 2;
        }
        throw new IOException("too much data loading class " + name);
    }

    public Class defineClassFromBytes(String name, byte[] b, boolean resolve) {
        this.definePackage(name);
        Class<?> clazz = this.defineClass(name, b, 0, b.length);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected void definePackage(String className) {
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return;
        }
        try {
            this.definePackage(className.substring(0, i), null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected Class loadClassLocally(String name) throws ClassNotFoundException {
        try {
            byte[] b = this.loadClassBytes(name);
            return this.defineClassFromBytes(name, b, true);
        }
        catch (Throwable ex) {
            throw new ClassNotFoundException(name, ex);
        }
    }

    protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("com.sun.") || name.startsWith("org.apache.xerces.") || name.startsWith("org.xml.sax.") || name.startsWith("org.w3c.dom.")) {
            return this.getParent().loadClass(name);
        }
        return null;
    }

    protected synchronized void install() {
        try {
            Class clazz = this.loadClassLocally("org.jboss.aop.AspectManager");
            Class[] transformSig = new Class[]{ClassLoader.class, String.class, Class.class, ProtectionDomain.class, [B.class};
            this.transform = clazz.getMethod("transform", transformSig);
            this.instance = clazz.getMethod("instance", new Class[0]);
            clazz = this.loadClassLocally("org.jboss.aop.AspectXmlLoader");
            this.deployXML = clazz.getMethod("deployXML", URL.class);
            this.state = 1;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Error initializing system classloader", t);
        }
    }

    protected synchronized void initialize() {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        Thread.currentThread().setContextClassLoader(this);
        try {
            try {
                System.setProperty("jboss.aop.optimized", "false");
                this.aspectManager = this.instance.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
            this.state = 3;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Error installing aspect manager", t);
        }
        try {
            Enumeration<URL> enumeration = this.getParent().getResources("META-INF/jboss-aop.xml");
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                this.deployXML.invoke(null, url);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error("Error deploying aop configrations", t);
        }
    }
}

