/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javassist.CtMethod;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.PayloadKey;

public class MethodMetaData
implements MetaDataResolver {
    Map methodMetaData = new ConcurrentReaderHashMap();
    HashMap inexactMatches;

    public boolean hasTag(String group) {
        Iterator values = this.methodMetaData.values().iterator();
        while (values.hasNext()) {
            SimpleMetaData map = (SimpleMetaData)values.next();
            if (!map.hasTag(group)) continue;
            return true;
        }
        return false;
    }

    public void tagMethod(Method method, Object tag) {
        this.addMethodMetaData(method, tag, (Object)"$tagged$", new Object(), PayloadKey.TRANSIENT);
    }

    public void addMethodMetaData(Method method, Object tag, Object attr, Object value) {
        this.addMethodMetaData(method, tag, attr, value, PayloadKey.MARSHALLED, true);
    }

    public void addMethodMetaData(Method method, Object tag, Object attr, Object value, boolean exactMatch) {
        this.addMethodMetaData(method, tag, attr, value, PayloadKey.MARSHALLED, exactMatch);
    }

    public void addMethodMetaData(Method method, Object tag, Object attr, Object value, PayloadKey type) {
        this.addMethodMetaData(method.toString(), tag, attr, value, type, true);
    }

    public void addMethodMetaData(Method method, Object tag, Object attr, Object value, PayloadKey type, boolean exactMatch) {
        this.addMethodMetaData(method.toString(), tag, attr, value, type, exactMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMethodMetaData(String key, Object tag, Object attr, Object value, PayloadKey type, boolean exactMatch) {
        Map map = this.methodMetaData;
        synchronized (map) {
            SimpleMetaData methodData = (SimpleMetaData)this.methodMetaData.get(key);
            if (methodData == null) {
                methodData = new SimpleMetaData();
                this.methodMetaData.put(key, methodData);
            }
            methodData.addMetaData(tag, attr, value, type);
        }
        this.manageInexactMatches(key, tag, attr, exactMatch);
    }

    private synchronized void manageInexactMatches(String key, Object tag, Object attr, boolean exactMatch) {
        if (!exactMatch) {
            HashMap<Object, Boolean> attrs;
            HashMap<Object, HashMap<Object, Boolean>> tags;
            if (this.inexactMatches == null) {
                this.inexactMatches = new HashMap();
            }
            if ((tags = (HashMap<Object, HashMap<Object, Boolean>>)this.inexactMatches.get(key)) == null) {
                tags = new HashMap<Object, HashMap<Object, Boolean>>();
                this.inexactMatches.put(key, tags);
            }
            if ((attrs = (HashMap<Object, Boolean>)tags.get(tag)) == null) {
                attrs = new HashMap<Object, Boolean>();
                tags.put(tag, attrs);
            }
            attrs.put(attr, Boolean.TRUE);
        } else {
            if (this.inexactMatches == null) {
                return;
            }
            HashMap tags = (HashMap)this.inexactMatches.get(key);
            if (tags == null) {
                return;
            }
            HashMap attrs = (HashMap)tags.get(tag);
            if (attrs == null) {
                return;
            }
            attrs.remove(attr);
        }
    }

    public synchronized boolean tagWasMatchedInexactly(Method method, Object tag, Object attr) {
        if (this.inexactMatches == null) {
            return false;
        }
        HashMap tags = (HashMap)this.inexactMatches.get(method.toString());
        if (tags == null) {
            return false;
        }
        HashMap attrs = (HashMap)tags.get(tag);
        if (attrs == null) {
            return false;
        }
        return attrs.get(attr) != null;
    }

    public boolean hasTag(Method method, String tag) {
        SimpleMetaData meta = this.getMethodMetaData(method);
        if (meta == null) {
            return false;
        }
        return meta.hasTag(tag);
    }

    public Iterator getMethods() {
        return this.methodMetaData.keySet().iterator();
    }

    public SimpleMetaData getMethodMetaData(String method) {
        return (SimpleMetaData)this.methodMetaData.get(method);
    }

    public SimpleMetaData getMethodMetaData(Method method) {
        return this.getMethodMetaData(method.toString());
    }

    public Object getMethodMetaData(Method method, Object tag, Object attr) {
        SimpleMetaData methodData = (SimpleMetaData)this.methodMetaData.get(method.toString());
        if (methodData == null) {
            return null;
        }
        return methodData.getMetaData(tag, attr);
    }

    public void clear() {
        this.methodMetaData.clear();
    }

    public Object resolve(Invocation invocation, Object tag, Object attr) {
        MethodInvocation methodInvocation = (MethodInvocation)invocation;
        return this.getMethodMetaData(methodInvocation.getMethod(), tag, attr);
    }

    public SimpleMetaData getAllMetaData(Invocation invocation) {
        MethodInvocation methodInvocation = (MethodInvocation)invocation;
        return (SimpleMetaData)this.methodMetaData.get(methodInvocation.getMethod().toString());
    }

    private String getCtMethodKey(CtMethod method) {
        return method.getName() + ":" + method.getSignature();
    }

    public void tagMethod(CtMethod method, Object tag) {
        this.addMethodMetaData(method, tag, (Object)"$tagged$", (Object)PayloadKey.TRANSIENT);
    }

    public void addMethodMetaData(CtMethod method, Object tag, Object attr, Object value) {
        this.addMethodMetaData(this.getCtMethodKey(method), tag, attr, value, PayloadKey.MARSHALLED, true);
    }

    public void addMethodMetaData(CtMethod method, Object tag, Object attr, Object value, PayloadKey type) {
        this.addMethodMetaData(this.getCtMethodKey(method), tag, attr, value, type, true);
    }

    public boolean hasGroup(CtMethod method, String tag) {
        SimpleMetaData meta = this.getMethodMetaData(this.getCtMethodKey(method));
        if (meta == null) {
            return false;
        }
        return meta.hasTag(tag);
    }
}

