/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.Iterator;
import javassist.CtMember;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutInfo;

public class JoinpointFullClassifier
extends JoinpointClassifier {
    protected JoinpointClassification classifyJoinpoint(CtMember member, Advisor advisor, JoinpointClassifier.Matcher joinpointMatcher) throws NotFoundException {
        JoinpointClassification classification = JoinpointClassification.NOT_INSTRUMENTED;
        Collection pointcuts = advisor.getManager().getPointcutInfos().values();
        boolean dynamicAop = true;
        Iterator it = pointcuts.iterator();
        while (it.hasNext()) {
            Pointcut pointcut;
            PointcutInfo pointcutInfo = (PointcutInfo)it.next();
            if (classification == JoinpointClassification.PREPARED && pointcutInfo.getBinding() == null || !joinpointMatcher.matches(pointcut = pointcutInfo.getPointcut(), advisor, member)) continue;
            if (pointcutInfo.getBinding() == null) {
                classification = JoinpointClassification.PREPARED;
                continue;
            }
            if (pointcutInfo.isDynamicAop()) {
                classification = JoinpointClassification.DYNAMICALY_WRAPPED;
                continue;
            }
            classification = JoinpointClassification.WRAPPED;
            break;
        }
        return classification;
    }
}

