/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation.compiler;

import java.util.Iterator;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.aop.annotation.ast.ASTAnnotation;
import org.jboss.aop.annotation.ast.ASTChar;
import org.jboss.aop.annotation.ast.ASTIdentifier;
import org.jboss.aop.annotation.ast.ASTMemberValueArrayInitializer;
import org.jboss.aop.annotation.ast.ASTMemberValuePair;
import org.jboss.aop.annotation.ast.ASTMemberValuePairs;
import org.jboss.aop.annotation.ast.ASTSingleMemberValue;
import org.jboss.aop.annotation.ast.ASTStart;
import org.jboss.aop.annotation.ast.ASTString;
import org.jboss.aop.annotation.ast.AnnotationParserVisitor;
import org.jboss.aop.annotation.ast.SimpleNode;
import org.jboss.aop.annotation.compiler.MemberValueCreation;
import org.jboss.aop.annotation.compiler.MemberValuePopulate;

public class AnnotationInfoCreator
implements AnnotationParserVisitor {
    private ClassPool pool;
    private ConstPool cp;
    private Annotation base;

    public AnnotationInfoCreator(ClassPool pool, ConstPool cp, Annotation base) {
        this.pool = pool;
        this.cp = cp;
        this.base = base;
    }

    public Object visit(ASTMemberValuePairs node, Object data) {
        node.childrenAccept(this, data);
        return null;
    }

    public Object visit(ASTMemberValuePair node, Object data) {
        String name = node.getIdentifier().getValue();
        MemberValue mv = this.base.getMemberValue(name);
        if (mv == null) {
            Iterator it = this.base.getMemberNames().iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
            throw new RuntimeException("member value is null for created annotation: " + this.base.getTypeName() + " for name: " + name);
        }
        node.getValue().jjtAccept(this, mv);
        return data;
    }

    public Object visit(ASTSingleMemberValue node, Object data) {
        if (this.base.getMemberNames().size() > 1) {
            throw new RuntimeException("single value expected from annotation: " + this.base.getTypeName());
        }
        Set set = this.base.getMemberNames();
        MemberValue mv = this.base.getMemberValue((String)set.iterator().next());
        node.getValue().jjtAccept(this, mv);
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        MemberValue mv = (MemberValue)data;
        MemberValuePopulate mvc = new MemberValuePopulate(node.getValue());
        mv.accept((MemberValueVisitor)mvc);
        return null;
    }

    public Object visit(ASTString node, Object data) {
        StringMemberValue mv = (StringMemberValue)data;
        mv.setValue(node.getValue());
        return null;
    }

    public Object visit(ASTChar node, Object data) {
        CharMemberValue mv = (CharMemberValue)data;
        mv.setValue(node.getValue());
        return null;
    }

    public Object visit(ASTMemberValueArrayInitializer node, Object data) {
        ArrayMemberValue mv = (ArrayMemberValue)data;
        int size = node.jjtGetNumChildren();
        MemberValue[] elements = new MemberValue[size];
        MemberValueCreation mvc = new MemberValueCreation(this.cp);
        for (int i = 0; i < size; ++i) {
            mv.getType().accept((MemberValueVisitor)mvc);
            elements[i] = mvc.value;
            node.jjtGetChild(i).jjtAccept(this, elements[i]);
        }
        mv.setValue(elements);
        return null;
    }

    public Object visit(ASTAnnotation node, Object data) {
        try {
            CtClass annotation = this.pool.get(node.getIdentifier());
            Annotation info = new Annotation(this.cp, annotation);
            AnnotationInfoCreator creator = new AnnotationInfoCreator(this.pool, this.cp, info);
            node.childrenAccept(creator, data);
            AnnotationMemberValue mv = (AnnotationMemberValue)data;
            mv.setValue(info);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTStart node, Object data) {
        return null;
    }

    public static Annotation createAnnotationInfo(ClassPool pool, ConstPool cp, ASTAnnotation node) throws Exception {
        CtClass annotation = pool.get(node.getIdentifier());
        Annotation info = new Annotation(cp, annotation);
        AnnotationInfoCreator creator = new AnnotationInfoCreator(pool, cp, info);
        if (node.jjtGetNumChildren() > 0) {
            node.jjtGetChild(0).jjtAccept(creator, null);
        }
        return info;
    }
}

