/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.OptimizedMethodInvocations;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.util.ReflectToJavassist;

public class PerVmAdvice {
    private static long counter = 0L;

    public static synchronized Interceptor generateOptimized(Joinpoint joinpoint, AspectManager manager, String adviceName, AspectDefinition a) throws Exception {
        Object aspect = manager.getPerVMAspect(a);
        return PerVmAdvice.generateInterceptor(joinpoint, aspect, adviceName);
    }

    public static Interceptor generateInterceptor(Joinpoint joinpoint, Object aspect, String adviceName) throws Exception {
        Method[] methods = aspect.getClass().getMethods();
        ArrayList<Method> matches = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(adviceName)) continue;
            matches.add(methods[i]);
        }
        if (matches.size() == 1) {
            Method method = (Method)matches.get(0);
            if (joinpoint instanceof MethodJoinpoint && (method.getParameterTypes().length == 0 || method.getParameterTypes().length > 1 || !Invocation.class.isAssignableFrom(method.getParameterTypes()[0]))) {
                return PerVmAdvice.generateArgsInterceptor(aspect, method, joinpoint);
            }
        }
        ClassPool pool = AspectManager.instance().findClassPool(aspect.getClass().getClassLoader());
        CtClass clazz = pool.makeClass("org.jboss.aop.advice." + aspect.getClass().getName() + counter++);
        CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
        CtClass abstractAdviceClass = pool.get("org.jboss.aop.advice.AbstractAdvice");
        clazz.setSuperclass(abstractAdviceClass);
        CtClass aspectClass = pool.get(aspect.getClass().getName());
        CtField field = new CtField(aspectClass, "aspectField", clazz);
        field.setModifiers(1);
        clazz.addField(field);
        CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
        CtMethod getName = CtNewMethod.make((CtClass)getNameTemplate.getReturnType(), (String)"getName", (CtClass[])getNameTemplate.getParameterTypes(), (CtClass[])getNameTemplate.getExceptionTypes(), null, (CtClass)clazz);
        String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + adviceName + "\"; " + "}";
        getName.setBody(getNameBody);
        getName.setModifiers(1);
        clazz.addMethod(getName);
        String invokeBody = "public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws java.lang.Throwable {  ";
        if (matches.size() > 1) {
            for (int i = 0; i < matches.size(); ++i) {
                Method advice = (Method)matches.get(i);
                String param = advice.getParameterTypes()[0].getName();
                invokeBody = invokeBody + "   if (invocation instanceof " + param + ") return aspectField." + adviceName + "((" + param + ")invocation); ";
            }
            invokeBody = invokeBody + "   return (org.jboss.aop.joinpoint.Invocation)null; ";
        } else {
            Method advice = (Method)matches.get(0);
            String param = advice.getParameterTypes()[0].getName();
            invokeBody = invokeBody + "return aspectField." + adviceName + "((" + param + ")invocation); ";
        }
        invokeBody = invokeBody + "}";
        CtMethod invoke = CtNewMethod.make((String)invokeBody, (CtClass)clazz);
        invoke.setModifiers(1);
        clazz.addMethod(invoke);
        Class iclass = clazz.toClass();
        Interceptor rtn = (Interceptor)iclass.newInstance();
        Field f = iclass.getField("aspectField");
        f.set(rtn, aspect);
        return rtn;
    }

    public static Interceptor generateArgsInterceptor(Object aspect, Method advice, Joinpoint joinpoint) throws Exception {
        ClassPool pool = AspectManager.instance().findClassPool(aspect.getClass().getClassLoader());
        CtClass clazz = pool.makeClass("org.jboss.aop.advice." + aspect.getClass().getName() + counter++);
        CtClass interceptorInterface = pool.get("org.jboss.aop.advice.Interceptor");
        clazz.addInterface(interceptorInterface);
        CtClass aspectClass = pool.get(aspect.getClass().getName());
        CtField field = new CtField(aspectClass, "aspectField", clazz);
        field.setModifiers(1);
        clazz.addField(field);
        CtMethod getNameTemplate = interceptorInterface.getDeclaredMethod("getName");
        CtMethod getName = CtNewMethod.make((CtClass)getNameTemplate.getReturnType(), (String)"getName", (CtClass[])getNameTemplate.getParameterTypes(), (CtClass[])getNameTemplate.getExceptionTypes(), null, (CtClass)clazz);
        String getNameBody = "{    return \"" + aspect.getClass().getName() + "." + advice.getName() + "\"; " + "}";
        getName.setBody(getNameBody);
        getName.setModifiers(1);
        clazz.addMethod(getName);
        Method method = ((MethodJoinpoint)joinpoint).getMethod();
        String invocationType = null;
        invocationType = AspectManager.optimize ? OptimizedMethodInvocations.getOptimizedInvocationClassName(method) : MethodInvocation.class.getName();
        StringBuffer invokeBody = new StringBuffer("public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws java.lang.Throwable ");
        invokeBody.append("{     ").append(invocationType).append(" typedInvocation = (");
        invokeBody.append(invocationType).append(")invocation; ");
        if (!AspectManager.optimize) {
            invokeBody.append("   Object[] arguments = typedInvocation.getArguments();");
        }
        if (advice.getParameterTypes().length > 0 && Invocation.class.isAssignableFrom(advice.getParameterTypes()[0])) {
            PerVmAdvice.fillInvocationBody(invokeBody, advice, method);
        } else {
            PerVmAdvice.fillThreadStackBody(invokeBody, advice, method);
        }
        invokeBody.append('}');
        CtMethod invoke = null;
        try {
            invoke = CtNewMethod.make((String)invokeBody.toString(), (CtClass)clazz);
        }
        catch (CannotCompileException e) {
            System.out.println(invokeBody);
            throw e;
        }
        invoke.setModifiers(1);
        clazz.addMethod(invoke);
        Class iclass = clazz.toClass();
        Interceptor rtn = (Interceptor)iclass.newInstance();
        Field f = iclass.getField("aspectField");
        f.set(rtn, aspect);
        return rtn;
    }

    private static void fillThreadStackBody(StringBuffer invokeBody, Method advice, Method method) throws Exception {
        invokeBody.append("   org.jboss.aop.joinpoint.CurrentInvocation.push(invocation); ");
        invokeBody.append("   try {");
        invokeBody.append("return ($w)aspectField.").append(advice.getName());
        invokeBody.append("(");
        PerVmAdvice.appendParamList(invokeBody, 0, advice.getParameterTypes(), method.getParameterTypes());
        invokeBody.append(");");
        invokeBody.append("   } finally { org.jboss.aop.joinpoint.CurrentInvocation.pop(); }");
    }

    private static void fillInvocationBody(StringBuffer invokeBody, Method advice, Method method) {
        invokeBody.append("   return ($w)aspectField.").append(advice.getName());
        invokeBody.append("(typedInvocation, ");
        PerVmAdvice.appendParamList(invokeBody, 1, advice.getParameterTypes(), method.getParameterTypes());
        invokeBody.append(");");
    }

    private static void appendParamList(StringBuffer code, int offset, Class[] adviceParams, Class[] joinPointParams) {
        block9: {
            int i;
            if (adviceParams.length <= 0) break block9;
            int[] paramIndexes = new int[adviceParams.length];
            boolean[] assignedParams = new boolean[joinPointParams.length];
            for (i = offset; i < adviceParams.length; ++i) {
                int j;
                for (j = 0; j < joinPointParams.length && (!adviceParams[i].equals(joinPointParams[j]) || assignedParams[j]); ++j) {
                }
                if (j == joinPointParams.length) {
                    for (j = 0; j < joinPointParams.length && (!adviceParams[i].isAssignableFrom(joinPointParams[j]) || assignedParams[j]); ++j) {
                    }
                    if (j == joinPointParams.length) {
                        throw new RuntimeException();
                    }
                }
                assignedParams[j] = true;
                paramIndexes[i] = j;
            }
            if (AspectManager.optimize) {
                code.append("typedInvocation.arg").append(paramIndexes[offset]);
                for (i = offset + 1; i < paramIndexes.length; ++i) {
                    code.append(", typedInvocation.arg");
                    code.append(paramIndexes[i]);
                }
            } else {
                code.append(ReflectToJavassist.castInvocationValueToTypeString(adviceParams[offset], "arguments[" + paramIndexes[offset] + "]"));
                for (i = offset + 1; i < paramIndexes.length; ++i) {
                    code.append(", ");
                    code.append(ReflectToJavassist.castInvocationValueToTypeString(adviceParams[i], "arguments[" + paramIndexes[i] + "]"));
                }
            }
        }
    }
}

