/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.sharedtable.jmx;

import com.clustercontrol.sharedtable.SharedTable;
import com.clustercontrol.sharedtable.jmx.SharedTableServiceMBean;
import com.clustercontrol.sharedtable.job.CheckJob;
import java.text.ParseException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;

public class SharedTableService
extends ServiceMBeanSupport
implements SharedTableServiceMBean {
    private String jndiName = "SharedTable";
    private String quartzJndiName = null;
    private String checkInterval = "34 */10 * * * ? *";
    private long keepAlive;
    private final String m_checkJobName = "CHECK_JOB";
    private final String m_checkJobGroup = "SHAREDTABLE";
    private SharedTable sharedTable;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.log.info((Object)("setJndiName() SharedTableService : " + jndiName));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            NamingException ne;
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
        }
    }

    public String getQuartzJndiName() {
        return this.quartzJndiName;
    }

    public void setQuartzJndiName(String jndiName) {
        this.quartzJndiName = jndiName;
    }

    public long getKeepAlive() {
        if (this.sharedTable != null) {
            return this.sharedTable.getKeepAlive();
        }
        return -1L;
    }

    public void setKeepAlive(long keepAlive) {
        if (this.sharedTable != null) {
            this.keepAlive = keepAlive;
            this.sharedTable.setKeepAlive(keepAlive);
        }
    }

    public String getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(String checkInterval) {
        this.checkInterval = checkInterval;
    }

    public String getName() {
        return "SharedTableService(" + this.jndiName + ")";
    }

    public String printTableInfo() {
        return this.sharedTable.getTableListDebugInfo();
    }

    public void createService() {
        this.log.info((Object)("Create SharedTableService(" + this.jndiName + ")"));
        if (this.sharedTable == null) {
            this.sharedTable = SharedTable.getInstance();
            this.sharedTable.setKeepAlive(this.keepAlive);
        }
        this.log.info((Object)("Created SharedTableService(" + this.jndiName + ")"));
    }

    public void startService() throws NamingException {
        this.log.info((Object)("Start SharedTableService(" + this.jndiName + ")"));
        this.rebind();
        this.scheduleCheckJob();
        this.log.info((Object)("Started SharedTableService(" + this.jndiName + ")"));
    }

    private void scheduleCheckJob() {
        JobDetail job = new JobDetail("CHECK_JOB", "SHAREDTABLE", CheckJob.class);
        job.setDurability(true);
        job.getJobDataMap().put("jndiName", this.jndiName);
        CronTrigger cronTrigger = new CronTrigger("CHECK_JOB", "SHAREDTABLE");
        cronTrigger.setMisfireInstruction(2);
        try {
            cronTrigger.setCronExpression(this.checkInterval);
        }
        catch (ParseException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(this.quartzJndiName);
            Scheduler scheduler = (Scheduler)PortableRemoteObject.narrow((Object)obj, StdScheduler.class);
            scheduler.deleteJob("CHECK_JOB", "SHAREDTABLE");
            scheduler.scheduleJob(job, (Trigger)cronTrigger);
        }
        catch (NamingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SchedulerException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void stopService() throws NamingException {
        this.log.info((Object)("Stop SharedTableService(" + this.jndiName + ")"));
        this.unbind(this.jndiName);
        this.log.info((Object)("Stoped SharedTableService(" + this.jndiName + ")"));
    }

    public void destroyService() throws Exception {
        this.log.info((Object)("Destroy SharedTableService(" + this.jndiName + ")"));
        this.sharedTable = null;
        this.log.info((Object)("Destroyed SharedTableService(" + this.jndiName + ")"));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws NamingException {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = SharedTableService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this.sharedTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }
}

