/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.services;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.monitor.alarm.AlarmNotification;
import org.jboss.monitor.services.JMXNotificationAppenderMBean;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.mx.util.MBeanServerLocator;

public class JMXNotificationAppender
extends AppenderSkeleton
implements JMXNotificationAppenderMBean,
NotificationEmitter {
    public static final String DEFAULT_TYPE = "jboss.alarm.logging";
    private MBeanServer server = MBeanServerLocator.locateJBoss();
    private ObjectName objectName;
    private String objectNameString;
    private String notificationType = "jboss.alarm.logging";
    private JBossNotificationBroadcasterSupport emitter = new JBossNotificationBroadcasterSupport();

    public JMXNotificationAppender() {
        this.setThreshold((Priority)Level.WARN);
    }

    public void setObjectName(String objectNameString) throws Exception {
        this.unregister();
        if (this.server != null) {
            this.objectName = new ObjectName(objectNameString);
            this.server.registerMBean(this, this.objectName);
        }
        this.objectNameString = objectNameString;
    }

    public String getObjectName() {
        return this.objectNameString;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.emitter.getNotificationInfo();
    }

    public void close() {
        this.unregister();
        this.server = null;
        this.emitter = null;
        this.objectName = null;
        this.objectNameString = null;
        this.notificationType = null;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        Level level;
        String[] ts;
        String msg = this.layout.format(event);
        if (this.layout.ignoresThrowable() && (ts = event.getThrowableStrRep()) != null) {
            StringBuffer sbuf = new StringBuffer(msg);
            int len = ts.length;
            for (int i = 0; i < len; ++i) {
                sbuf.append(Layout.LINE_SEP).append(ts[i]);
            }
            msg = sbuf.toString();
        }
        int severity = (level = event.getLevel()) == Level.WARN ? 1 : (level == Level.ERROR ? 3 : (level == Level.FATAL ? 4 : 5));
        AlarmNotification alarm = new AlarmNotification(this.notificationType, this, null, severity, 3, this.emitter.nextNotificationSequenceNumber(), event.timeStamp, msg);
        this.emitter.sendNotification((Notification)alarm);
    }

    private void unregister() {
        if (this.server != null && this.objectName != null) {
            try {
                this.server.unregisterMBean(this.objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

