/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.remote;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.Referenceable;
import javax.sql.DataSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.proxy.ClientMethodInterceptor;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.resource.adapter.jdbc.remote.DataSourceFactory;
import org.jboss.resource.adapter.jdbc.remote.SerializableInputStream;
import org.jboss.resource.adapter.jdbc.remote.SerializableParameterMetaData;
import org.jboss.resource.adapter.jdbc.remote.SerializableReader;
import org.jboss.resource.adapter.jdbc.remote.SerializableResultSetMetaData;
import org.jboss.resource.adapter.jdbc.remote.StatementInterceptor;
import org.jboss.resource.adapter.jdbc.remote.WrapperDataSourceServiceMBean;
import org.jboss.resource.connectionmanager.ConnectionFactoryBindingService;
import org.jboss.system.Registry;
import org.jboss.util.Classes;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;

public class WrapperDataSourceService
extends ConnectionFactoryBindingService
implements WrapperDataSourceServiceMBean {
    private static Logger log = Logger.getLogger(WrapperDataSourceService.class);
    private ObjectName jmxInvokerName;
    private Invoker delegateInvoker;
    private Object theProxy;
    private HashMap marshalledInvocationMapping = new HashMap();
    private HashMap connectionMap = new HashMap();
    private HashMap statementMap = new HashMap();
    private HashMap resultSetMap = new HashMap();
    private HashMap lobMap = new HashMap();
    private HashMap databaseMetaDataMap = new HashMap();
    private boolean trace = log.isTraceEnabled();

    protected void startService() throws Exception {
        this.determineBindName();
        this.createConnectionFactory();
        if (this.jmxInvokerName != null) {
            this.createProxy();
            this.calculateMethodHases();
            this.bindConnectionFactory();
        } else {
            super.bindConnectionFactory();
        }
    }

    protected void stopService() throws Exception {
        this.unbindConnectionFactory();
        if (this.jmxInvokerName != null) {
            this.destroyProxy();
        }
    }

    protected void bindConnectionFactory() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            log.debug((Object)("Binding object '" + this.cf + "' into JNDI at '" + this.bindName + "'"));
            NonSerializableFactory.rebind((String)this.bindName, (Object)this.cf);
            Referenceable referenceable = (Referenceable)this.cf;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.theProxy);
            oos.close();
            byte[] proxyBytes = baos.toByteArray();
            BinaryRefAddr dsAddr = new BinaryRefAddr("ProxyData", proxyBytes);
            String factory = DataSourceFactory.class.getName();
            Reference dsRef = new Reference("javax.sql.DataSource", dsAddr, factory, null);
            referenceable.setReference(dsRef);
            baos.reset();
            ObjectOutputStream oos2 = new ObjectOutputStream(baos);
            oos2.writeObject(DataSourceFactory.vmID);
            oos2.close();
            byte[] id = baos.toByteArray();
            BinaryRefAddr localAddr = new BinaryRefAddr("VMID", id);
            dsRef.add(localAddr);
            StringRefAddr jndiRef = new StringRefAddr("JndiName", this.bindName);
            dsRef.add(jndiRef);
            Util.rebind((Context)ctx, (String)this.bindName, (Object)this.cf);
            log.info((Object)("Bound ConnectionManager '" + this.serviceName + "' to JNDI name '" + this.bindName + "'"));
        }
        catch (NamingException ne) {
            throw new DeploymentException("Could not bind ConnectionFactory into jndi: " + this.bindName, (Throwable)ne);
        }
        finally {
            ctx.close();
        }
    }

    public ObjectName getJMXInvokerName() {
        return this.jmxInvokerName;
    }

    public void setJMXInvokerName(ObjectName jmxInvokerName) {
        this.jmxInvokerName = jmxInvokerName;
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object value;
        block13: {
            if (invocation instanceof MarshalledInvocation) {
                MarshalledInvocation mi = (MarshalledInvocation)invocation;
                mi.setMethodMap((Map)this.marshalledInvocationMapping);
            }
            Method method = invocation.getMethod();
            Class<Wrapper> methodClass = method.getDeclaringClass();
            Object[] args = invocation.getArguments();
            value = null;
            try {
                if (methodClass.isAssignableFrom(DataSource.class)) {
                    InitialContext ctx = new InitialContext();
                    DataSource ds = (DataSource)ctx.lookup(this.bindName);
                    value = this.doDataSourceMethod(ds, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(Connection.class)) {
                    Integer id = (Integer)invocation.getId();
                    Connection conn = (Connection)this.connectionMap.get(id);
                    if (conn == null) {
                        throw new IllegalAccessException("Failed to find connection: " + id);
                    }
                    value = this.doConnectionMethod(conn, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(Statement.class) || methodClass.isAssignableFrom(PreparedStatement.class) || methodClass.isAssignableFrom(CallableStatement.class)) {
                    Integer id = (Integer)invocation.getId();
                    Statement stmt = (Statement)this.statementMap.get(id);
                    if (stmt == null) {
                        throw new SQLException("Failed to find Statement: " + id);
                    }
                    value = this.doStatementMethod(stmt, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(ResultSet.class)) {
                    Integer id = (Integer)invocation.getId();
                    ResultSet results = (ResultSet)this.resultSetMap.get(id);
                    if (results == null) {
                        throw new IllegalAccessException("Failed to find ResultSet: " + id);
                    }
                    value = this.doResultSetMethod(results, method, args);
                    break block13;
                }
                if (methodClass.isAssignableFrom(DatabaseMetaData.class)) {
                    Integer id = (Integer)invocation.getId();
                    DatabaseMetaData dbMetaData = (DatabaseMetaData)this.databaseMetaDataMap.get(id);
                    if (dbMetaData == null) {
                        throw new IllegalAccessException("Failed to find DatabaseMetaData: " + id);
                    }
                    value = this.doDatabaseMetaDataMethod(dbMetaData, method, args);
                    break block13;
                }
                throw new UnsupportedOperationException("Do not know how to handle method=" + method);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new UndeclaredThrowableException(t, method.toString());
            }
        }
        return value;
    }

    protected void createProxy() throws Exception {
        this.delegateInvoker = (Invoker)Registry.lookup((Object)this.jmxInvokerName);
        log.debug((Object)("Using delegate: " + this.delegateInvoker + " for invoker=" + this.jmxInvokerName));
        ObjectName targetName = this.getServiceName();
        Integer nameHash = new Integer(targetName.hashCode());
        Registry.bind((Object)nameHash, (Object)targetName);
        Object cacheID = null;
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = new Class[]{DataSource.class};
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(ClientMethodInterceptor.class);
        interceptorClasses.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        this.theProxy = proxyFactory.createProxy(cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        log.debug((Object)("Created proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", nameHash=" + nameHash));
    }

    protected void destroyProxy() throws Exception {
        ObjectName name = this.getServiceName();
        Integer nameHash = new Integer(name.hashCode());
        Registry.unbind((Object)nameHash);
    }

    protected void calculateMethodHases() throws Exception {
        Method[] methods = DataSource.class.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method method = methods[m];
            Long hash = new Long(MarshalledInvocation.calculateHash((Method)method));
            this.marshalledInvocationMapping.put(hash, method);
        }
        Map m = MarshalledInvocation.methodToHashesMap(Connection.class);
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap(Statement.class);
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap(CallableStatement.class);
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap(PreparedStatement.class);
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap(ResultSet.class);
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
        m = MarshalledInvocation.methodToHashesMap(DatabaseMetaData.class);
        this.displayHashes(m);
        this.marshalledInvocationMapping.putAll(m);
    }

    private Object doDataSourceMethod(DataSource ds, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Object value = method.invoke((Object)ds, args);
        if (value instanceof Connection) {
            value = this.createConnectionProxy(value);
        } else if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doConnectionMethod(Connection conn, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, SQLException {
        Object value;
        if (this.trace) {
            log.trace((Object)("doConnectionMethod, conn=" + conn + ", method=" + method));
        }
        if ((value = method.invoke((Object)conn, args)) instanceof Statement) {
            value = this.createStatementProxy(value);
        } else if (value instanceof DatabaseMetaData) {
            value = this.createDatabaseMetaData(value);
        } else if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doStatementMethod(Statement stmt, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, SQLException {
        Object value;
        if (this.trace) {
            log.trace((Object)("doStatementMethod, conn=" + stmt + ", method=" + method));
        }
        if (method.getName().equals("close")) {
            Integer id = new Integer(stmt.hashCode());
            this.statementMap.remove(id);
            log.debug((Object)("Closed Statement=" + id));
        }
        if ((value = method.invoke((Object)stmt, args)) instanceof ResultSet) {
            value = this.createResultSetProxy(value);
        } else if (value instanceof ResultSetMetaData) {
            ResultSetMetaData rmd = (ResultSetMetaData)value;
            value = new SerializableResultSetMetaData(rmd);
        } else if (value instanceof ParameterMetaData) {
            ParameterMetaData pmd = (ParameterMetaData)value;
            value = new SerializableParameterMetaData(pmd);
        } else if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doResultSetMethod(ResultSet results, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, SQLException, IOException {
        Closeable ins;
        Object value;
        if (this.trace) {
            log.trace((Object)("doStatementMethod, results=" + results + ", method=" + method));
        }
        if (method.getName().equals("close")) {
            Integer id = new Integer(results.hashCode());
            this.resultSetMap.remove(id);
            log.debug((Object)("Closed ResultSet=" + id));
        }
        if ((value = method.invoke((Object)results, args)) instanceof ResultSetMetaData) {
            ResultSetMetaData rmd = (ResultSetMetaData)value;
            value = new SerializableResultSetMetaData(rmd);
        }
        if (("getBinaryStream".equals(method.getName()) || "getAsciiStream".equals(method.getName())) && value instanceof InputStream) {
            ins = (InputStream)value;
            value = new SerializableInputStream((InputStream)ins);
        } else if ("getCharacterStream".equals(method.getName()) && value instanceof Reader) {
            ins = (Reader)value;
            value = new SerializableReader((Reader)ins);
        } else if ("getClob".equals(method.getName()) || "getBlob".equals(method.getName())) {
            value = this.createLobProxy(value);
        }
        if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object doDatabaseMetaDataMethod(DatabaseMetaData dbMetaData, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Object value;
        if (this.trace) {
            log.trace((Object)("doDatabaseMetaDataMethod, dbMetaData=" + dbMetaData + ", method=" + method));
        }
        if ((value = method.invoke((Object)dbMetaData, args)) instanceof ResultSet) {
            value = this.createResultSetProxy(value);
        } else if (value instanceof Connection) {
            value = this.createConnectionProxy(value);
        }
        if (value != null && !(value instanceof Serializable)) {
            throw new IllegalAccessException("Method=" + method + " does not return Serializable");
        }
        return value;
    }

    private Object createConnectionProxy(Object conn) {
        Integer cacheID = new Integer(conn.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = new Class[]{Connection.class};
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(ClientMethodInterceptor.class);
        interceptorClasses.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object connProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.connectionMap.put(cacheID, conn);
        log.debug((Object)("Created Connection proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return connProxy;
    }

    private Object createStatementProxy(Object stmt) {
        Integer cacheID = new Integer(stmt.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = this.getJavaInterfaces(stmt.getClass());
        ArrayList<Class<InvokerInterceptor>> interceptorClasses = new ArrayList<Class<InvokerInterceptor>>();
        interceptorClasses.add(StatementInterceptor.class);
        interceptorClasses.add(ClientMethodInterceptor.class);
        interceptorClasses.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object stmtProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.statementMap.put(cacheID, stmt);
        log.debug((Object)("Created Statement proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return stmtProxy;
    }

    private Object createResultSetProxy(Object results) {
        Integer cacheID = new Integer(results.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = this.getJavaInterfaces(results.getClass());
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(ClientMethodInterceptor.class);
        interceptorClasses.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object resultsProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.resultSetMap.put(cacheID, results);
        log.debug((Object)("Created ResultSet proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return resultsProxy;
    }

    private Object createLobProxy(Object results) {
        Integer cacheID = new Integer(results.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = results.getClass().getInterfaces();
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(ClientMethodInterceptor.class);
        interceptorClasses.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object resultsProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.lobMap.put(cacheID, results);
        log.debug((Object)("Created LOB proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return resultsProxy;
    }

    private Object createDatabaseMetaData(Object dbMetaData) {
        Integer cacheID = new Integer(dbMetaData.hashCode());
        ObjectName targetName = this.getServiceName();
        String proxyBindingName = null;
        String jndiName = null;
        Class[] ifaces = new Class[]{DatabaseMetaData.class};
        ArrayList<Class> interceptorClasses = new ArrayList<Class>();
        interceptorClasses.add(ClientMethodInterceptor.class);
        interceptorClasses.add(InvokerInterceptor.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        Object dbMetaDataProxy = proxyFactory.createProxy((Object)cacheID, targetName, this.delegateInvoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces);
        this.databaseMetaDataMap.put(cacheID, dbMetaData);
        log.debug((Object)("Created DatabaseMetadata proxy for invoker=" + this.jmxInvokerName + ", targetName=" + targetName + ", cacheID=" + cacheID));
        return dbMetaDataProxy;
    }

    private void displayHashes(Map m) {
        if (!this.trace) {
            return;
        }
        for (Long key : m.keySet()) {
            log.trace((Object)(key + "=" + m.get(key)));
        }
    }

    private Class[] getJavaInterfaces(Class clazz) {
        ArrayList tmp = new ArrayList();
        Classes.getAllInterfaces(tmp, (Class)clazz);
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            Class c = (Class)iter.next();
            if (c.getName().startsWith("java")) continue;
            iter.remove();
        }
        Class[] ifaces = new Class[tmp.size()];
        return tmp.toArray(ifaces);
    }
}

