/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.bean;

import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.Facility;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstUtil;
import com.clustercontrol.performance.util.CalculationMethod;
import com.clustercontrol.poller.NotInitializedException;
import com.clustercontrol.sharedtable.DataTable;
import com.clustercontrol.sharedtable.DataTableNotFoundException;
import com.clustercontrol.sharedtable.SharedTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends Facility {
    private static final long serialVersionUID = -5989756829710363991L;
    protected static Log m_log = LogFactory.getLog(Node.class);
    private static Object modifyLock = new Object();
    private static SharedTable sharedTable = null;
    private HashMap<String, HashMap<String, CollectorDeviceInfoData>> m_deviceMap;
    private String platformId;
    private String subPlatformId;
    private DataTable currentTable;
    private DataTable previousTable;
    private long lastCollectTime;

    public Node(String facilityID, String faclityName, String platformId, String subPlatformId, List<CollectorDeviceInfoData> deviceDataList) {
        super(facilityID, faclityName, "node");
        m_log.debug((Object)("create Node " + facilityID + ", " + faclityName + ", " + platformId + ", " + subPlatformId));
        this.platformId = platformId;
        this.subPlatformId = subPlatformId;
        this.m_deviceMap = new HashMap();
        for (CollectorDeviceInfoData deviceData : deviceDataList) {
            String deviceType = deviceData.getDeviceType();
            if (!this.m_deviceMap.containsKey(deviceType)) {
                this.m_deviceMap.put(deviceType, new HashMap());
            }
            HashMap<String, CollectorDeviceInfoData> mapByDeviceType = this.m_deviceMap.get(deviceType);
            mapByDeviceType.put(deviceData.getDisplayName(), deviceData);
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = modifyLock;
        synchronized (object) {
            if (sharedTable != null) {
                return;
            }
            try {
                InitialContext ctx = new InitialContext();
                Object obj = ctx.lookup("SharedTable");
                sharedTable = (SharedTable)PortableRemoteObject.narrow((Object)obj, SharedTable.class);
            }
            catch (NamingException e) {
                m_log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public double calcValue(CollectorItemInfo itemInfo) {
        CollectorDeviceInfoData deviceData = null;
        try {
            CollectorItemCodeMstLocal mstData = CollectorItemCodeMstUtil.getLocalHome().findByPrimaryKey(itemInfo.getItemCode());
            String deviceType = mstData.getDeviceType();
            m_log.debug((Object)("DeviceType : " + deviceType));
            if (deviceType != null && !"".equals(deviceType)) {
                HashMap<String, CollectorDeviceInfoData> deviceTypeMap = this.m_deviceMap.get(deviceType);
                if (m_log.isDebugEnabled()) {
                    for (String key : deviceTypeMap.keySet()) {
                        m_log.debug((Object)deviceTypeMap.get(key));
                    }
                }
                if (deviceTypeMap != null) {
                    deviceData = deviceTypeMap.get(itemInfo.getDisplayName());
                }
            }
        }
        catch (FinderException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return Double.NaN;
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
            return Double.NaN;
        }
        double value = CalculationMethod.getPerformance(this.platformId, this.subPlatformId, itemInfo, deviceData, this.currentTable, this.previousTable);
        m_log.debug((Object)("calcValue() : " + this.getFacilityId() + " " + itemInfo.getItemCode() + " " + itemInfo.getDisplayName() + "  " + value));
        if (!Double.isNaN(value)) {
            this.setCalcValueBuffer(new CollectorItemInfo(itemInfo.getCollectorId(), itemInfo.getItemCode(), itemInfo.getDisplayName()), value);
        }
        return value;
    }

    public long fetchMibValue(String collectorId) throws NotInitializedException {
        m_log.debug((Object)"fetchMibValue() start :");
        try {
            if (sharedTable == null) {
                this.initialize();
            }
            List tables = sharedTable.getLastDataTables("PRF", this.getFacilityId(), collectorId, 2);
            this.currentTable = (DataTable)tables.get(0);
            this.previousTable = (DataTable)tables.get(1);
        }
        catch (DataTableNotFoundException e) {
            String facilityId = this.getFacilityId();
            m_log.warn((Object)("create table : " + facilityId));
            try {
                InitialContext ctx = new InitialContext();
                SharedTable sst = (SharedTable)ctx.lookup("SharedTable");
                if (!sst.containsTable("PRF", facilityId, 2)) {
                    sst.createDataTable("PRF", facilityId, 2);
                }
            }
            catch (NamingException e1) {
                m_log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        this.lastCollectTime = this.currentTable.getLastModify();
        m_log.debug((Object)"fetchMibValue() end :");
        return this.lastCollectTime;
    }

    public HashSet<Facility> getNode(HashSet<Facility> nodeSet) {
        nodeSet.add(this);
        return nodeSet;
    }

    @Override
    public int getNodeCount() {
        return 1;
    }
}

