/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.factory.Notice;
import com.clustercontrol.jobmanagement.factory.OperationJob;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperateSuspendOfJob
extends OperationJob {
    protected static Log m_log = LogFactory.getLog(OperateSuspendOfJob.class);

    public void suspendJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("suspendJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 100) {
            sessionJob.setStatus(200);
            sessionJob.setEnd_date(new Date());
            Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, 100);
            if (collection != null && collection.size() > 0) {
                for (JobRelationInfoLocal relation : collection) {
                    this.suspendJob(relation.getSession_id(), relation.getJob_id());
                }
            }
        }
    }

    public void releaseSuspendJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("releaseSuspendJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        this.releaseSuspend(sessionId, jobId);
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, 200);
        if (collection != null && collection.size() > 0) {
            for (JobRelationInfoLocal relation : collection) {
                String relationJobId = relation.getJob_id();
                relation = null;
                this.releaseSuspendJob(sessionId, relationJobId);
            }
        }
        if (sessionJob != null) {
            boolean endAll = true;
            if (sessionJob.getJobInfo().getJob_type() == 2) {
                endAll = this.checkJobEnd(sessionJob);
            } else {
                Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                for (JobRelationInfoLocal relation1 : sameHierarchy) {
                    JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
                    if (sessionJob1.getStatus() == 300 || sessionJob1.getStatus() == 301) continue;
                    endAll = false;
                    break;
                }
                Iterator itr = null;
                sameHierarchy = null;
            }
            if (endAll) {
                Integer endStatus = this.checkEndStatus(sessionId, jobId);
                this.setEndStaus(sessionId, jobId, 300, endStatus, null);
                new Notice().notify(sessionId, jobId, endStatus);
                JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
                String parentJobId = relation.getParent_job_id();
                relation = null;
                if (parentJobId.compareTo("TOP") != 0) {
                    this.endJob(sessionId, jobId);
                }
            }
        }
    }

    protected void releaseSuspend(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug((Object)("releaseSuspend() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 200) {
            sessionJob.setStatus(100);
            JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
            String parentJobId = relation.getParent_job_id();
            relation = null;
            sessionJob = null;
            if (parentJobId.compareTo("TOP") != 0) {
                this.releaseSuspend(sessionId, parentJobId);
            }
        }
    }
}

