/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.jobmanagement.bean.DelayNotifyConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;
import com.clustercontrol.jobmanagement.factory.OperateMaintenanceOfJob;
import com.clustercontrol.jobmanagement.factory.OperationJob;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import com.clustercontrol.jobmanagement.util.SendTopic;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperateStopOfJob
extends OperationJob {
    protected static Log m_log = LogFactory.getLog(OperateStopOfJob.class);

    public void stopJob(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        if (sessionJob != null && sessionJob.getStatus() == 100) {
            if (facilityId != null && facilityId.length() > 0) {
                this.stopNode(sessionId, jobId, facilityId);
            } else {
                sessionJob.setStatus(101);
                JobInfoLocal job = sessionJob.getJobInfo();
                if (job.getJob_type() == 2) {
                    this.stopNode(sessionId, jobId, null);
                    if (this.checkAllNodeStop(sessionJob)) {
                        sessionJob.setStatus(201);
                        this.stopJob(sessionId, jobId);
                        JobStartInfoLocal start = job.getJobStartInfo();
                        int flg = sessionJob.getDelay_notify_flg();
                        int operationFlg = DelayNotifyConstant.getOperation(flg);
                        if (operationFlg == 30) {
                            new OperateMaintenanceOfJob().maintenanceJob(sessionId, jobId, null, start.getEnd_delay_operation_end_value());
                        }
                        start = null;
                        sessionJob = null;
                    }
                } else {
                    Collection collection = JobRelationInfoUtil.getLocalHome().findByStatus(sessionId, jobId, 100);
                    if (collection != null && collection.size() > 0) {
                        for (JobRelationInfoLocal relation : collection) {
                            this.stopJob(relation.getSession_id(), relation.getJob_id(), null);
                        }
                    }
                    boolean endAll = true;
                    collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
                    if (collection != null && collection.size() > 0) {
                        for (JobRelationInfoLocal relation1 : collection) {
                            JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
                            relation1 = null;
                            int status = sessionJob1.getStatus();
                            sessionJob1 = null;
                            if (status != 101 && status != 100) continue;
                            endAll = false;
                            break;
                        }
                    }
                    if (endAll) {
                        sessionJob.setStatus(201);
                        if (job.getJob_type() == 1) {
                            JobStartInfoLocal start = job.getJobStartInfo();
                            int flg = sessionJob.getDelay_notify_flg();
                            int operationFlg = DelayNotifyConstant.getOperation(flg);
                            if (operationFlg == 30) {
                                new OperateMaintenanceOfJob().maintenanceJob(sessionId, jobId, null, start.getEnd_delay_operation_end_value());
                            }
                            start = null;
                        }
                        sessionJob = null;
                    }
                }
            }
        }
    }

    protected void stopJob(String sessionId, String jobId) throws FinderException, NamingException {
        JobSessionJobLocal parentSessionJob;
        m_log.debug((Object)("stopJob() : sessionId=" + sessionId + ", jobId=" + jobId));
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
        String parentJobId = relation.getParent_job_id();
        relation = null;
        boolean endAll = true;
        Collection sameHierarchy = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, parentJobId);
        for (JobRelationInfoLocal relation1 : sameHierarchy) {
            JobSessionJobLocal sessionJob1 = relation1.getJobSessionJob();
            relation1 = null;
            int status = sessionJob1.getStatus();
            sessionJob1 = null;
            if (status != 101 && status != 100) continue;
            endAll = false;
            break;
        }
        sessionJob = null;
        if (endAll && parentJobId.compareTo("TOP") != 0 && (parentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, parentJobId))).getStatus() == 101) {
            parentSessionJob.setStatus(201);
            this.stopJob(sessionId, parentJobId);
            JobInfoLocal job = parentSessionJob.getJobInfo();
            if (job.getJob_type() == 1) {
                JobStartInfoLocal start = job.getJobStartInfo();
                int flg = parentSessionJob.getDelay_notify_flg();
                int operationFlg = DelayNotifyConstant.getOperation(flg);
                if (operationFlg == 30) {
                    new OperateMaintenanceOfJob().maintenanceJob(sessionId, parentJobId, null, start.getEnd_delay_operation_end_value());
                }
                start = null;
            }
            job = null;
            parentSessionJob = null;
        }
    }

    protected void stopNode(String sessionId, String jobId, String facilityId) throws FinderException, NamingException {
        m_log.debug((Object)("stopNode() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId));
        this.checkTimeout(sessionId, jobId);
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobInfoLocal job = sessionJob.getJobInfo();
        JobCommandInfoLocal command = job.getJobCommandInfo();
        if (facilityId != null && facilityId.length() > 0) {
            JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
            if (sessionNode.getStatus() == 100) {
                if (sessionNode.getAgent_check() == 2 && command.getStop_command() != null && command.getStop_command().length() > 0) {
                    sessionNode.setStatus(101);
                    sessionNode.setStart_date(null);
                    RunInstructionInfo instructionInfo = new RunInstructionInfo();
                    instructionInfo.setSessionId(sessionNode.getSession_id());
                    instructionInfo.setJobId(sessionNode.getJob_id());
                    instructionInfo.setFacilityId(sessionNode.getFacility_id());
                    String stopCommand = ParameterUtil.replaceSessionParameterValue(sessionId, command.getStop_command());
                    instructionInfo.setCommand(stopCommand);
                    instructionInfo.setUser(command.getEffective_user());
                    instructionInfo.setCommandType(1);
                    try {
                        SendTopic send = new SendTopic("topic/clustercontrolJobManagementExecute");
                        send.put(instructionInfo);
                    }
                    catch (Exception e) {
                        m_log.debug((Object)("stopNode() : \u5b9f\u884c\u505c\u6b62\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                    }
                } else {
                    sessionNode.setStatus(201);
                }
            }
        } else {
            Collection collection = sessionJob.getJobSessionNode();
            if (collection != null && collection.size() > 0) {
                for (JobSessionNodeLocal sessionNode : collection) {
                    if (sessionNode.getStatus() != 100) continue;
                    if (sessionNode.getAgent_check() == 2 && command.getStop_command() != null && command.getStop_command().length() > 0) {
                        sessionNode.setStatus(101);
                        sessionNode.setStart_date(null);
                        RunInstructionInfo instructionInfo = new RunInstructionInfo();
                        instructionInfo.setSessionId(sessionNode.getSession_id());
                        instructionInfo.setJobId(sessionNode.getJob_id());
                        instructionInfo.setFacilityId(sessionNode.getFacility_id());
                        String stopCommand = ParameterUtil.replaceSessionParameterValue(sessionId, command.getStop_command());
                        instructionInfo.setCommand(stopCommand);
                        instructionInfo.setUser(command.getEffective_user());
                        instructionInfo.setCommandType(1);
                        try {
                            SendTopic send = new SendTopic("topic/clustercontrolJobManagementExecute");
                            send.put(instructionInfo);
                        }
                        catch (Exception e) {
                            m_log.debug((Object)("stopNode() : \u5b9f\u884c\u505c\u6b62\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                        }
                        continue;
                    }
                    sessionNode.setStatus(201);
                }
            }
        }
    }
}

