/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.ws.scout.registry.infomodel.RegistryEntryImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;

public class ServiceImpl
extends RegistryEntryImpl
implements Service {
    private Organization org = null;
    private Collection serviceBindings = new ArrayList();

    public ServiceImpl(LifeCycleManager lifeCycleManager) {
        super(lifeCycleManager);
    }

    public void addServiceBinding(ServiceBinding sb) throws JAXRException {
        this.serviceBindings.add(sb);
        ((ServiceBindingImpl)sb).setService(this);
    }

    public void addServiceBindings(Collection col) throws JAXRException {
        try {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.addServiceBinding((ServiceBinding)iter.next());
            }
        }
        catch (ClassCastException ce) {
            throw new UnexpectedObjectException(ce.getLocalizedMessage());
        }
    }

    public Organization getProvidingOrganization() throws JAXRException {
        if (this.org == null) {
            return super.getSubmittingOrganization();
        }
        return this.org;
    }

    public Collection getServiceBindings() throws JAXRException {
        return this.serviceBindings;
    }

    public void removeServiceBinding(ServiceBinding serviceBinding) throws JAXRException {
        this.serviceBindings.remove(serviceBinding);
    }

    public void removeServiceBindings(Collection collection) throws JAXRException {
        this.serviceBindings.removeAll(collection);
    }

    public void setProvidingOrganization(Organization organization) throws JAXRException {
        this.org = organization;
    }
}

