/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.callback.statistics;

import java.util.HashMap;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;

public class CallbackClient {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;

    public void getPolledCallbacks(String locatorURI) throws Throwable {
        System.out.println("Calling remoting server with locator uri of: " + locatorURI);
        InvokerLocator locator = new InvokerLocator(locatorURI);
        Client client = new Client(locator);
        client.connect();
        CallbackHandler callbackHandler = new CallbackHandler();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("reportStatistics", "true");
        client.addListener((InvokerCallbackHandler)callbackHandler, metadata);
        Thread.sleep(20000L);
        client.removeListener(callbackHandler);
        client.disconnect();
    }

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        CallbackClient callbackClient = new CallbackClient();
        try {
            callbackClient.getPolledCallbacks(locatorURI);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public class CallbackHandler
    implements InvokerCallbackHandler {
        public void handleCallback(Callback callback) throws HandleCallbackException {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Received push callback.");
            System.out.println("Received callback value of: " + callback.getCallbackObject());
            System.out.println("Received callback server invoker of: " + callback.getServerLocator());
        }
    }
}

