/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jms.delegate.Cancel;
import org.jboss.jms.delegate.DefaultCancel;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class SessionCancelDeliveriesRequest
extends RequestSupport {
    private List cancels;

    public SessionCancelDeliveriesRequest() {
    }

    public SessionCancelDeliveriesRequest(String objectId, byte version, List cancels) {
        super(objectId, 307, version);
        this.cancels = cancels;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        int size = is.readInt();
        this.cancels = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            long deliveryId = is.readLong();
            int deliveryCount = is.readInt();
            boolean expired = is.readBoolean();
            boolean reachedMax = is.readBoolean();
            DefaultCancel cancel = new DefaultCancel(deliveryId, deliveryCount, expired, reachedMax);
            this.cancels.add(cancel);
        }
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.cancelDeliveries(this.cancels);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeInt(this.cancels.size());
        for (Cancel cancel : this.cancels) {
            os.writeLong(cancel.getDeliveryId());
            os.writeInt(cancel.getDeliveryCount());
            os.writeBoolean(cancel.isExpired());
            os.writeBoolean(cancel.isReachedMaxDeliveryAttempts());
        }
        os.flush();
    }
}

