/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;

public class FailoverValve2 {
    private static final Logger log = Logger.getLogger(FailoverValve2.class);
    private static boolean trace = log.isTraceEnabled();
    private Set threads;
    private int count;
    private boolean locked;

    public FailoverValve2() {
        trace = log.isTraceEnabled();
        if (trace) {
            this.threads = new HashSet();
        }
    }

    public synchronized void enter() {
        if (trace) {
            log.trace((Object)(this + " entering"));
        }
        while (this.locked) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.count;
        if (trace) {
            this.threads.add(Thread.currentThread());
            log.trace((Object)(this + " entered"));
        }
    }

    public synchronized void leave() {
        if (trace) {
            log.trace((Object)(this + " leaving"));
        }
        --this.count;
        if (trace) {
            this.threads.remove(Thread.currentThread());
        }
        this.notifyAll();
        if (trace) {
            log.trace((Object)(this + " left"));
        }
    }

    public synchronized void close() {
        if (trace) {
            log.trace((Object)(this + " close " + (this.locked ? "LOCKED" : "UNLOCKED") + " valve"));
        }
        if (trace && this.threads.contains(Thread.currentThread())) {
            throw new IllegalStateException("Cannot close valve from inside valve");
        }
        while (this.locked) {
            if (trace) {
                log.trace((Object)(this + " is already closed, blocking until its opened"));
            }
            try {
                this.wait();
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (this.locked) continue;
            return;
        }
        this.locked = true;
        while (this.count > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (trace) {
            log.trace((Object)(this + " closed"));
        }
    }

    public synchronized void open() {
        if (trace) {
            log.trace((Object)(this + " opening " + (this.locked ? "LOCKED" : "UNLOCKED") + " valve"));
        }
        if (!this.locked) {
            return;
        }
        this.locked = false;
        this.notifyAll();
    }

    public String toString() {
        return "FailoverValve[" + System.identityHashCode(this) + "]";
    }
}

