/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.util.Collection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.buffer.SynchronizedBuffer;

public class BlockingBuffer
extends SynchronizedBuffer {
    private static final long serialVersionUID = 1719328905017860541L;

    public static Buffer decorate(Buffer buffer) {
        return new BlockingBuffer(buffer);
    }

    protected BlockingBuffer(Buffer buffer) {
        super(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.collection.add(o);
            this.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.collection.addAll(c);
            this.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new BufferUnderflowException();
                }
            }
            return this.getBuffer().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new BufferUnderflowException();
                }
            }
            return this.getBuffer().remove();
        }
    }
}

