/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi.configurations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarOutputStream;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.jboss.deployment.spi.DeploymentMetaData;
import org.jboss.deployment.spi.JarUtils;
import org.jboss.deployment.spi.beans.JBossConfigBeanProxy;
import org.jboss.deployment.spi.beans.WarConfigBeanRoot;

public class WarConfiguration
implements DeploymentConfiguration {
    private DeployableObject deployable;
    private HashMap configBeans;

    public WarConfiguration(DeployableObject deployable) {
        this.deployable = deployable;
        this.configBeans = new HashMap();
    }

    public DeployableObject getDeployableObject() {
        return this.deployable;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dd) throws ConfigurationException {
        if (this.configBeans.containsKey(dd.getFilename())) {
            return (DConfigBeanRoot)this.configBeans.get(dd.getFilename());
        }
        if (dd.getFilename().equals("WEB-INF/web.xml")) {
            WarConfigBeanRoot retval = new WarConfigBeanRoot(dd, this.deployable);
            this.configBeans.put(dd.getFilename(), retval);
            return retval;
        }
        return null;
    }

    public void removeDConfigBean(DConfigBeanRoot bean) throws BeanNotFoundException {
        String key = bean.getDDBean().getRoot().getFilename();
        if (!this.configBeans.containsKey(key)) {
            throw new BeanNotFoundException("BNF");
        }
        System.out.println("its here... not anymore");
        this.configBeans.remove(key);
    }

    public void save(OutputStream stream) throws ConfigurationException {
        JarOutputStream jos = null;
        DeploymentMetaData metaData = new DeploymentMetaData("WRONG.war");
        try {
            jos = new JarOutputStream(stream);
        }
        catch (Exception e) {
            return;
        }
        if (jos == null) {
            return;
        }
        Iterator setIterator = this.configBeans.keySet().iterator();
        while (setIterator.hasNext()) {
            String key = (String)setIterator.next();
            JBossConfigBeanProxy val = (JBossConfigBeanProxy)this.configBeans.get(key);
            val.save(jos, metaData);
        }
        try {
            String metaStr = metaData.toXMLString();
            JarUtils.addJarEntry(jos, "deployment-plan.xml", new ByteArrayInputStream(metaStr.getBytes()));
            jos.flush();
            jos.close();
        }
        catch (Exception e) {
            System.out.println("config IO exception error: " + e.getMessage());
        }
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream arg0, DDBeanRoot arg1) throws ConfigurationException {
        return null;
    }

    public void saveDConfigBean(OutputStream arg0, DConfigBeanRoot arg1) throws ConfigurationException {
    }

    public void restore(InputStream arg0) throws ConfigurationException {
    }
}

