/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.UIManager;
import org.jboss.remoting.samples.chat.client.ChatFrame;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.LocalStrategy;
import org.jboss.remoting.samples.chat.client.RemoteStrategy;
import org.jboss.remoting.samples.chat.utility.Debug;
import org.jboss.remoting.samples.chat.utility.Parameters;

public class Chat
extends CloseableFrame {
    boolean packFrame = false;

    public Chat(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
        }
        Parameters.initParameters(args);
        String debug = Parameters.getParameter("debug");
        if (debug != null && debug.charAt(0) == 'y') {
            Debug.turnOn();
        }
        RemoteStrategy remoteStrategy = null;
        ChatFrame frame = null;
        String remoteStrategyName = Parameters.getParameter("remoteStrategy");
        if (remoteStrategyName == null) {
            remoteStrategyName = "chat.client.RemoteStrategyXmlRmi_Impl";
        }
        try {
            remoteStrategy = (RemoteStrategy)Class.forName(remoteStrategyName).newInstance();
            System.out.println("chat: created remote strategy: " + remoteStrategyName);
        }
        catch (Exception e) {
            System.out.println("chat: unable to create RemoteStrategyImpl: " + remoteStrategyName);
            System.out.println(e.toString());
            System.exit(-1);
        }
        LocalStrategy localStrategy = new LocalStrategy(this, remoteStrategy);
        frame = new ChatFrame(localStrategy);
        frame.show();
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Chat(args);
    }
}

