/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.client.delegate.ClientConsumerDelegate;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.jms.wireformat.SessionCreateConsumerDelegateResponse;

public class SessionCreateConsumerDelegateRequest
extends RequestSupport {
    private JBossDestination dest;
    private String selector;
    private boolean noLocal;
    private String subName;
    private boolean connectionConsumer;
    private boolean autoFlowControl;

    public SessionCreateConsumerDelegateRequest() {
    }

    public SessionCreateConsumerDelegateRequest(String objectId, byte version, JBossDestination destination, String selector, boolean noLocal, String subName, boolean connectionConsumer, boolean autoFlowControl) {
        super(objectId, 301, version);
        this.dest = destination;
        this.selector = selector;
        this.noLocal = noLocal;
        this.subName = subName;
        this.connectionConsumer = connectionConsumer;
        this.autoFlowControl = autoFlowControl;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.dest = JBossDestination.readDestination(is);
        this.selector = this.readNullableString(is);
        this.noLocal = is.readBoolean();
        this.subName = this.readNullableString(is);
        this.connectionConsumer = is.readBoolean();
        this.autoFlowControl = is.readBoolean();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new SessionCreateConsumerDelegateResponse((ClientConsumerDelegate)endpoint.createConsumerDelegate(this.dest, this.selector, this.noLocal, this.subName, this.connectionConsumer, this.autoFlowControl));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        JBossDestination.writeDestination(os, this.dest);
        this.writeNullableString(this.selector, os);
        os.writeBoolean(this.noLocal);
        this.writeNullableString(this.subName, os);
        os.writeBoolean(this.connectionConsumer);
        os.writeBoolean(this.autoFlowControl);
        os.flush();
    }
}

