/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.jms.client.ClientAOPStackLoader;
import org.jboss.jms.client.JBossConnection;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.referenceable.SerializableObjectRefAddr;
import org.jboss.logging.Logger;

public class JBossConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory,
Serializable {
    private static final long serialVersionUID = -2810634789345348326L;
    private static final Logger log = Logger.getLogger(JBossConnectionFactory.class);
    protected ConnectionFactoryDelegate delegate;

    public JBossConnectionFactory(ConnectionFactoryDelegate delegate) {
        this.delegate = delegate;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 0);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 1);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, false, 2);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(null, null);
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 0);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(null, null);
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 1);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(null, null);
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return this.createConnectionInternal(username, password, true, 2);
    }

    public Reference getReference() throws NamingException {
        return new Reference("org.jboss.jms.client.JBossConnectionFactory", new SerializableObjectRefAddr("JBM-CF", this), "org.jboss.jms.referenceable.ConnectionFactoryObjectFactory", null);
    }

    public String toString() {
        return "JBossConnectionFactory->" + this.delegate;
    }

    public ConnectionFactoryDelegate getDelegate() {
        return this.delegate;
    }

    protected JBossConnection createConnectionInternal(String username, String password, boolean isXA, int type) throws JMSException {
        try {
            ClientAOPStackLoader.getInstance().load(this.delegate);
        }
        catch (Exception e) {
            String msg = "Failed to download and/or install client side AOP stack";
            log.error((Object)"Failed to download and/or install client side AOP stack", (Throwable)e);
            throw new RuntimeException("Failed to download and/or install client side AOP stack", e);
        }
        CreateConnectionResult res = this.delegate.createConnectionDelegate(username, password, -1);
        return new JBossConnection(res.getDelegate(), type);
    }
}

