/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Stack;
import org.jboss.jms.client.FailoverCommandCenter;
import org.jboss.logging.Logger;

public class FailoverValve {
    private static final Logger log = Logger.getLogger(FailoverValve.class);
    public static final long DEFAULT_ATTEMPT_TIMEOUT = 5000L;
    private static boolean trace = log.isTraceEnabled();
    private ThreadLocal counterLocal = new ThreadLocal();
    private ReadWriteLock lock;
    private int activeCloses = 0;
    private ThreadLocal stackCloses;
    private ThreadLocal stackEnters;
    private Map debugCloses;
    private Map debugEnters;
    private FailoverCommandCenter fcc;
    private long writeLockAttemptTimeout;

    public FailoverValve() {
        this(null, 5000L);
    }

    public FailoverValve(long attemptTiemout) {
        this(null, attemptTiemout);
    }

    public FailoverValve(FailoverCommandCenter fcc) {
        this(fcc, 5000L);
    }

    public FailoverValve(FailoverCommandCenter fcc, long attemptTiemout) {
        this.fcc = fcc;
        this.lock = new ReentrantWriterPreferenceReadWriteLock();
        this.writeLockAttemptTimeout = attemptTiemout;
        if (trace) {
            this.stackCloses = new ThreadLocal();
            this.stackEnters = new ThreadLocal();
            this.debugCloses = new ConcurrentHashMap();
            this.debugEnters = new ConcurrentHashMap();
        }
    }

    public void enter() throws InterruptedException {
        this.lock.readLock().acquire();
        ++this.getCounter().counter;
        if (trace) {
            Exception ex = new Exception();
            this.getStackEnters().push(ex);
            this.debugEnters.put(ex, Thread.currentThread());
        }
    }

    public void leave() throws InterruptedException {
        this.lock.readLock().release();
        if (this.getCounter().counter-- < 0) {
            throw new IllegalStateException("leave() was called without a prior enter() call");
        }
        if (trace) {
            Exception ex = (Exception)this.getStackEnters().pop();
            this.debugEnters.remove(ex);
        }
    }

    public void close() throws InterruptedException {
        log.debug((Object)(this + " close ..."));
        int counter = this.getCounter().counter;
        for (int i = 0; i < counter; ++i) {
            this.lock.readLock().release();
        }
        boolean acquired = false;
        do {
            if (acquired = this.lock.writeLock().attempt(this.writeLockAttemptTimeout)) continue;
            log.debug((Object)(this + " could not close, trying again ..."), (Throwable)new Exception());
            if (!trace) continue;
            log.trace((Object)this.debugValve());
        } while (!acquired);
        log.debug((Object)(this + " closed"));
        ++this.activeCloses;
        if (this.activeCloses > 1) {
            this.lock.writeLock().release();
            throw new IllegalStateException("Valve closed twice");
        }
        if (trace) {
            Exception ex = new Exception();
            this.getStackCloses().push(ex);
            this.debugCloses.put(ex, Thread.currentThread());
        }
    }

    public void open() throws InterruptedException {
        if (this.activeCloses <= 0) {
            throw new IllegalStateException("Valve not closed");
        }
        log.debug((Object)(this + " opening ..."));
        --this.activeCloses;
        this.lock.writeLock().release();
        int counter = this.getCounter().counter;
        for (int i = 0; i < counter; ++i) {
            this.lock.readLock().acquire();
        }
        if (trace) {
            Exception ex = (Exception)this.getStackCloses().pop();
            this.debugCloses.remove(ex);
        }
        log.debug((Object)(this + " opened"));
    }

    public long getWriteLockAttemptTimeout() {
        return this.writeLockAttemptTimeout;
    }

    public String toString() {
        return "FailoverValve[" + (this.fcc == null ? "UNINITIALIZED" : "connectionID=" + this.fcc.getConnectionState().getDelegate().getID()) + "]";
    }

    private Counter getCounter() {
        Counter localCounter = (Counter)this.counterLocal.get();
        if (localCounter == null) {
            localCounter = new Counter();
            this.counterLocal.set(localCounter);
        }
        return localCounter;
    }

    private Stack getStackCloses() {
        if (this.stackCloses.get() == null) {
            this.stackCloses.set(new Stack());
        }
        return (Stack)this.stackCloses.get();
    }

    private Stack getStackEnters() {
        if (this.stackEnters.get() == null) {
            this.stackEnters.set(new Stack());
        }
        return (Stack)this.stackEnters.get();
    }

    private synchronized String debugValve() {
        Exception e;
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        writer.println("********************** Debug Valve Information *************************");
        writer.println("Close owners");
        for (Map.Entry entry : this.debugCloses.entrySet()) {
            writer.println("Thread that owns a close =" + entry.getValue());
            writer.println("StackTrace:");
            e = (Exception)entry.getKey();
            e.printStackTrace(writer);
        }
        writer.println("Valve owners");
        for (Map.Entry entry : this.debugEnters.entrySet()) {
            writer.println("Thread that owns valve =" + entry.getValue());
            writer.println("StackTrace:");
            e = (Exception)entry.getKey();
            e.printStackTrace(writer);
        }
        return buffer.toString();
    }

    private static class Counter {
        int counter;

        private Counter() {
        }
    }
}

