/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.factory;

import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.ping.bean.PingResult;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoLocal;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoPK;
import com.clustercontrol.ping.ejb.entity.MonitorPingInfoUtil;
import com.clustercontrol.ping.util.PingProperties;
import com.clustercontrol.ping.util.ReachAddress;
import com.clustercontrol.ping.util.ReachAddressFping;
import com.clustercontrol.priority.util.PriorityJudgment;
import com.clustercontrol.util.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorPing
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorPing.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    public static boolean fpingEnable;
    protected static final ArrayList<String> m_attributeList;
    protected MonitorPingInfoLocal m_ping = null;
    protected int m_runCount = 1;
    protected int m_runInterval = 1000;
    protected int m_pingTimeout;
    protected String m_message = null;
    protected String m_unKnownMessage = null;
    protected String m_messageOrg = null;
    protected int m_lost = 0;
    protected long m_average = 0L;
    ReachAddress m_reachability = null;
    ReachAddressFping m_reachabilityFping = null;
    private ArrayList m_MsgOrg = null;
    private ArrayList m_MsgErr = null;
    private ArrayList m_MsgOrgV6 = null;
    private ArrayList m_MsgErrV6 = null;
    private Hashtable m_Target;

    public RunMonitorPing() throws NamingException, JMSException, CreateException {
        PingProperties.getProperties();
        fpingEnable = PingProperties.isFpingEnable();
    }

    public RunMonitor createMonitorInstance() throws NamingException, JMSException, CreateException {
        return new RunMonitorPing();
    }

    public boolean collect(String facilityId) {
        this.m_nodeDate = this.m_now.getTime();
        this.m_message = "";
        this.m_messageOrg = "";
        this.m_lost = 0;
        this.m_average = 0L;
        if (this.m_reachability == null) {
            this.m_reachability = new ReachAddress(this.m_runCount, this.m_runInterval, this.m_pingTimeout);
        }
        try {
            HashMap facilityAttrMap = this.m_repository.getNodeDetail(facilityId, m_attributeList);
            String ipNetworkNumber = (String)facilityAttrMap.get("ipNetworkNumber");
            String nodeName = (String)facilityAttrMap.get("ccNodeName");
            boolean result = this.m_reachability.isReachable(ipNetworkNumber, nodeName);
            this.m_message = this.m_reachability.getMessage();
            this.m_messageOrg = this.m_reachability.getMessageOrg();
            if (result) {
                this.m_lost = this.m_reachability.getLost();
                this.m_average = this.m_reachability.getAverage();
            }
            return result;
        }
        catch (FinderException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.ping.4");
            this.m_messageOrg = e.getMessage();
            return false;
        }
        catch (NamingException e) {
            m_log.debug((Object)("run():" + e.getMessage()));
            this.m_message = Messages.getString((String)"message.ping.4");
            this.m_messageOrg = e.getMessage();
            return false;
        }
    }

    public boolean collectFping(ArrayList facilityList, ArrayList priporityList) {
        this.m_nodeDate = this.m_now.getTime();
        ArrayList<String> hosts = new ArrayList<String>();
        ArrayList<String> hostsv6 = new ArrayList<String>();
        this.m_Target = new Hashtable();
        String facilityId = null;
        int version = 4;
        for (int index = 0; index < facilityList.size(); ++index) {
            facilityId = (String)facilityList.get(index);
            if (facilityId == null || "".equals(facilityId)) continue;
            String[] node = new String[2];
            try {
                HashMap facilityAttrMap = this.m_repository.getNodeDetail(facilityId, m_attributeList);
                version = (Integer)facilityAttrMap.get("ipProtocolNumber") != null ? (Integer)facilityAttrMap.get("ipProtocolNumber") : 4;
                if (version == 6) {
                    InetAddress[] ip = InetAddress.getAllByName((String)facilityAttrMap.get("ccIpNetworkNumberV6"));
                    if (ip.length != 1) {
                        throw new UnknownHostException();
                    }
                    node[0] = ip[0].getHostAddress();
                    if (node[0] != null && !node[0].equals("")) {
                        hostsv6.add(node[0]);
                    }
                } else {
                    node[0] = (String)facilityAttrMap.get("ipNetworkNumber");
                    if (node[0] != null && !node[0].equals("")) {
                        hosts.add(node[0]);
                    }
                }
                if (node[0] == null || node[0].equals("")) continue;
                node[1] = (String)facilityAttrMap.get("ccNodeName");
                this.m_Target.put(facilityId, node);
                continue;
            }
            catch (FinderException e) {
                m_log.error((Object)("collectFping():" + e.getMessage()));
                this.m_message = Messages.getString((String)"message.ping.4");
                this.m_messageOrg = e.getMessage();
                return false;
            }
            catch (NamingException e) {
                m_log.error((Object)("collectFping():" + e.getMessage()));
                this.m_message = Messages.getString((String)"message.ping.4");
                this.m_messageOrg = e.getMessage();
                return false;
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (this.m_reachabilityFping == null) {
            this.m_reachabilityFping = new ReachAddressFping(this.m_runCount, this.m_runInterval, this.m_pingTimeout);
        }
        boolean result = true;
        boolean resultTmp = true;
        if (hosts.size() != 0) {
            result = this.m_reachabilityFping.isReachable(hosts, 4);
            this.m_MsgErr = this.m_reachabilityFping.getM_errMsg();
            this.m_MsgOrg = this.m_reachabilityFping.getM_resultMsg();
        }
        if (hostsv6.size() != 0) {
            resultTmp = this.m_reachabilityFping.isReachable(hostsv6, 6);
            this.m_MsgErrV6 = this.m_reachabilityFping.getM_errMsg();
            this.m_MsgOrgV6 = this.m_reachabilityFping.getM_resultMsg();
            result &= resultTmp;
        }
        return result;
    }

    private Hashtable wrapUpFping(ArrayList messages, int count, int version) {
        Hashtable<String, PingResult> ret = new Hashtable<String, PingResult>();
        float average = 0.0f;
        Pattern patternIp = version == 6 ? Pattern.compile("^([0-9].*)|^(\\:\\:.*)") : Pattern.compile("^([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}.*)");
        Pattern patternSp = Pattern.compile("(\\s:\\s|\\s)+");
        for (int index = 0; index < messages.size(); ++index) {
            float reachRatio;
            int lost;
            Matcher matcher = patternIp.matcher((String)messages.get(index));
            if (!matcher.matches()) continue;
            String[] strs = patternSp.split((String)messages.get(index));
            float max = 0.0f;
            float min = Float.MAX_VALUE;
            int num = 0;
            for (int index1 = 1; index1 <= count; ++index1) {
                if (strs[index1].equals("-")) continue;
                ++num;
                if (max < Float.parseFloat(strs[index1])) {
                    max = Float.parseFloat(strs[index1]);
                }
                if (min > Float.parseFloat(strs[index1])) {
                    min = Float.parseFloat(strs[index1]);
                }
                average += Float.parseFloat(strs[index1]);
            }
            average /= (float)count;
            StringBuffer buffer = new StringBuffer();
            buffer.append("Pinging " + strs[0] + " (" + strs[0] + ") .\n\n");
            if (num == 0) {
                lost = 100;
                reachRatio = 0.0f;
                for (int index1 = 0; index1 < count; ++index1) {
                    buffer.append("Reply from " + strs[0] + " icmp_seq=" + index + " Destination Host Unreachable");
                }
                buffer.append("\nPing statistics for " + strs[0] + ":\n");
                buffer.append("Packets: Sent = " + count + ", Received = " + num + ", Lost = " + (count - num) + " (" + lost + "% loss),");
            } else {
                lost = (count - num) * 100 / count;
                reachRatio = num * 100 / count;
                buffer.append("\nPing statistics for " + strs[0] + ":\n");
                buffer.append("Packets: Sent = " + count + ", Received = " + num + ", Lost = " + (count - num) + " (" + lost + "% loss),");
                buffer.append("Approximate round trip times in milli-seconds:\n");
                buffer.append("\tMinimum = " + min + "ms, Maximum = " + max + "ms, Average = " + average + "ms\n");
            }
            String msgOrg = buffer.toString();
            String msg = "Packets: Sent = " + count + ", Received = " + num + ", Lost = " + (count - num) + " (" + lost + "% loss)";
            PingResult res = new PingResult(strs[0], msg, msgOrg, lost, average, reachRatio);
            ret.put(strs[0], res);
            msg = "";
            msgOrg = "";
            lost = 100;
            average = 0.0f;
            reachRatio = 0.0f;
        }
        return ret;
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorPingInfoPK pk = new MonitorPingInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_ping = MonitorPingInfoUtil.getLocalHome().findByPrimaryKey(pk);
        if (this.m_ping.getRunCount() != null) {
            this.m_runCount = this.m_ping.getRunCount();
        }
        if (this.m_ping.getRunInterval() != null) {
            this.m_runInterval = this.m_ping.getRunInterval();
        }
        if (this.m_ping.getTimeout() != null) {
            this.m_pingTimeout = this.m_ping.getTimeout();
        }
    }

    public int getCheckResult(boolean ret) {
        int result = -1;
        MonitorNumericValueInfo info = null;
        if (ret) {
            info = (MonitorNumericValueInfo)this.m_judgementInfoList.get(3);
            result = (double)this.m_lost <= info.getThresholdLowerLimit() && (double)this.m_average <= info.getThresholdUpperLimit() ? 3 : ((double)this.m_lost <= (info = (MonitorNumericValueInfo)this.m_judgementInfoList.get(2)).getThresholdLowerLimit() && (double)this.m_average <= info.getThresholdUpperLimit() ? 2 : 0);
        }
        return result;
    }

    public String getMessageId(int id) {
        if (id == 3) {
            return MESSAGE_ID_INFO;
        }
        if (id == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (id == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int id) {
        return this.m_message;
    }

    public String getMessageOrg(int id) {
        return this.m_messageOrg;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public boolean runMonitorInfo() throws FinderException, RemoveException, JMSException, NamingException, CreateException {
        this.m_now = new Date();
        this.m_priorityMap = new HashMap();
        this.m_priorityMap.put(3, new ArrayList());
        this.m_priorityMap.put(2, new ArrayList());
        this.m_priorityMap.put(0, new ArrayList());
        this.m_priorityMap.put(1, new ArrayList());
        try {
            boolean run = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
            if (!run) {
                return true;
            }
            this.setJudgementInfo();
            this.setCheckInfo();
            ArrayList facilityList = this.m_repository.getExecTargetFacilityIdList(this.m_facilityId);
            if (facilityList.size() == 0) {
                return true;
            }
            ArrayList<Integer> priorityList = new ArrayList<Integer>();
            if (!fpingEnable) {
                String facilityId = null;
                for (int index = 0; index < facilityList.size(); ++index) {
                    facilityId = (String)facilityList.get(index);
                    if (facilityId == null || "".equals(facilityId)) continue;
                    boolean ret = this.collect(facilityId);
                    int checkResult = this.getCheckResult(ret);
                    if (1 == this.m_monitorBlock || 2 == this.m_monitorBlock) {
                        int priority = this.getPriority(checkResult);
                        priorityList.add(priority);
                        this.setPriorityMap(priority, facilityId);
                    }
                    if (this.m_nodeDate > this.m_scopeDate) {
                        this.m_scopeDate = this.m_nodeDate;
                    }
                    if (0 != this.m_monitorBlock && (1 != this.m_monitorBlock || !this.m_isNode) && 2 != this.m_monitorBlock) continue;
                    this.notify(true, facilityId, checkResult, new Date(this.m_nodeDate));
                }
            } else {
                boolean ret = this.collectFping(facilityList, priorityList);
                if (ret) {
                    Hashtable fpingResultSet = new Hashtable();
                    Hashtable fpingResultSetV6 = new Hashtable();
                    if (this.m_MsgErr != null) {
                        fpingResultSet = this.wrapUpFping(this.m_MsgErr, this.m_runCount, 4);
                    }
                    if (this.m_MsgErrV6 != null) {
                        fpingResultSetV6 = this.wrapUpFping(this.m_MsgErrV6, this.m_runCount, 6);
                    }
                    if (fpingResultSet.size() == 0) {
                        fpingResultSet = fpingResultSetV6;
                    } else if (fpingResultSetV6.size() != 0) {
                        fpingResultSet.putAll(fpingResultSetV6);
                    }
                    for (String targetFacility : facilityList) {
                        String[] node = (String[])this.m_Target.get(targetFacility);
                        if (node == null) continue;
                        PingResult nodeResult = (PingResult)fpingResultSet.get(node[0]);
                        if (nodeResult == null) {
                            m_log.error((Object)"Fping no response.");
                            continue;
                        }
                        this.m_lost = nodeResult.getLost();
                        this.m_average = (long)nodeResult.getAverage();
                        this.m_message = nodeResult.getMesseage();
                        this.m_messageOrg = nodeResult.getMesseageOrg();
                        int checkResult = this.getCheckResult(true);
                        if (1 == this.m_monitorBlock || 2 == this.m_monitorBlock) {
                            int priority = this.getPriority(checkResult);
                            priorityList.add(priority);
                            this.setPriorityMap(priority, targetFacility);
                        }
                        if (this.m_nodeDate > this.m_scopeDate) {
                            this.m_scopeDate = this.m_nodeDate;
                        }
                        if (0 != this.m_monitorBlock && (1 != this.m_monitorBlock || !this.m_isNode) && 2 != this.m_monitorBlock) continue;
                        this.notify(true, targetFacility, checkResult, new Date(this.m_nodeDate));
                    }
                }
            }
            if (!(this.m_isNode || 1 != this.m_monitorBlock && 2 != this.m_monitorBlock)) {
                Integer priority = PriorityJudgment.judgment(priorityList);
                if (priority == null) {
                    priority = this.m_failurePriority;
                }
                Date generationDate = null;
                generationDate = this.m_scopeDate > 0L ? new Date(this.m_scopeDate) : this.m_now;
                this.notify(false, this.m_facilityId, priority, generationDate);
            }
            return true;
        }
        catch (FinderException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.error((Object)("run(): \u76e3\u8996\u5bfe\u8c61ID:" + this.m_monitorTypeId + ",\u76e3\u8996\u9805\u76eeID\uff1a" + this.m_monitorId + ", " + e.getMessage()));
            throw e;
        }
    }

    public void run(String monitorTypeId, String monitorId) throws FinderException, RemoveException, JMSException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException, CreateException {
        super.run(monitorTypeId, monitorId);
    }

    static {
        m_attributeList = new ArrayList();
        m_attributeList.add("ipProtocolNumber");
        m_attributeList.add("ccNodeName");
        m_attributeList.add("ipNetworkNumber");
        m_attributeList.add("ccIpNetworkNumberV6");
    }
}

