/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPElement;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.extensions.xop.jaxws.AttachmentScanResult;
import org.jboss.ws.extensions.xop.jaxws.ReflectiveAttachmentRefScanner;
import org.jboss.ws.metadata.acessor.ReflectiveMethodAccessor;
import org.jboss.ws.metadata.umdm.AccessorFactory;
import org.jboss.ws.metadata.umdm.AccessorFactoryCreator;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.wsf.common.JavaUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMetaData {
    private final Logger log = Logger.getLogger(ParameterMetaData.class);
    private OperationMetaData opMetaData;
    private QName xmlName;
    private String partName;
    private QName xmlType;
    private String javaTypeName;
    private Class javaType;
    private ParameterMode mode;
    private Set<String> mimeTypes;
    private boolean inHeader;
    private boolean isSwA;
    private boolean isXOP;
    private boolean isSwaRef;
    private List<WrappedParameter> wrappedParameters;
    private int index;
    private boolean soapArrayParam;
    private QName soapArrayCompType;
    private AccessorFactoryCreator accessorFactoryCreator = ReflectiveMethodAccessor.FACTORY_CREATOR;
    private static final List<String> messageTypes = new ArrayList<String>();

    public ParameterMetaData(OperationMetaData opMetaData, QName xmlName, QName xmlType, String javaTypeName) {
        this(opMetaData, xmlName, javaTypeName);
        this.setXmlType(xmlType);
    }

    public ParameterMetaData(OperationMetaData opMetaData, QName xmlName, String javaTypeName) {
        if (xmlName == null) {
            throw new IllegalArgumentException("Invalid null xmlName argument");
        }
        if (xmlName.getNamespaceURI().length() > 0) {
            xmlName = new QName(xmlName.getNamespaceURI(), xmlName.getLocalPart());
        }
        this.xmlName = xmlName;
        this.opMetaData = opMetaData;
        this.mode = ParameterMode.IN;
        this.javaTypeName = javaTypeName;
        this.partName = xmlName.getLocalPart();
    }

    private static boolean matchParameter(Method method, int index, Class expectedType, Set<Integer> matches, boolean exact, boolean holder) {
        boolean matchTypes;
        Class<?> returnType = method.getReturnType();
        if (index == -1 && ParameterMetaData.matchTypes(returnType, expectedType, exact, false)) {
            return true;
        }
        Class<?>[] classParameters = method.getParameterTypes();
        if (index < 0 || index >= classParameters.length) {
            return false;
        }
        if (JavaUtils.isRetro14()) {
            matchTypes = ParameterMetaData.matchTypes(classParameters[index], expectedType, exact, holder);
        } else {
            Type[] genericParameters = method.getGenericParameterTypes();
            matchTypes = ParameterMetaData.matchTypes(genericParameters[index], expectedType, exact, holder);
        }
        if (matchTypes) {
            matches.add(index);
            return true;
        }
        return false;
    }

    private static boolean matchTypes(Type actualType, Class expectedType, boolean exact, boolean holder) {
        if (holder && !HolderUtils.isHolderType(actualType)) {
            return false;
        }
        Type valueType = holder ? HolderUtils.getValueType(actualType) : actualType;
        Class valueClass = JavaUtils.erasure((Type)valueType);
        return ParameterMetaData.matchTypesInternal(valueClass, expectedType, exact);
    }

    private static boolean matchTypes(Class actualType, Class expectedType, boolean exact, boolean holder) {
        if (holder && !HolderUtils.isHolderType(actualType)) {
            return false;
        }
        Class valueClass = holder ? HolderUtils.getValueType(actualType) : actualType;
        return ParameterMetaData.matchTypesInternal(valueClass, expectedType, exact);
    }

    private static boolean matchTypesInternal(Class valueClass, Class expectedType, boolean exact) {
        boolean matched;
        ArrayList<Class> anyTypes = new ArrayList<Class>();
        anyTypes.add(SOAPElement.class);
        anyTypes.add(Element.class);
        if (exact) {
            matched = valueClass.getName().equals(expectedType.getName());
            if (!matched && anyTypes.contains(valueClass)) {
                matched = anyTypes.contains(expectedType);
            }
        } else {
            matched = JavaUtils.isAssignableFrom((Class)valueClass, (Class)expectedType);
        }
        return matched;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public QName getXmlName() {
        return this.xmlName;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(QName xmlType) {
        if (xmlType == null) {
            throw new IllegalArgumentException("Invalid null xmlType");
        }
        this.xmlType = xmlType.getNamespaceURI().length() > 0 ? new QName(xmlType.getNamespaceURI(), xmlType.getLocalPart()) : xmlType;
        if ("http://www.jboss.org/jbossws/attachment/mimetype".equals(xmlType.getNamespaceURI())) {
            String mimeType = this.convertXmlTypeToMimeType(xmlType);
            this.setMimeTypes(mimeType);
            this.isSwA = true;
        }
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public void setJavaTypeName(String typeName) {
        UnifiedMetaData wsMetaData = this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData();
        if (wsMetaData.isEagerInitialized() && !UnifiedMetaData.isFinalRelease()) {
            this.log.warn((Object)"Set java type name after eager initialization", (Throwable)new IllegalStateException());
        }
        this.javaTypeName = typeName;
        this.javaType = null;
    }

    public Class loadWrapperBean() {
        Class wrapperBean = null;
        try {
            ClassLoader loader = this.getClassLoader();
            wrapperBean = JavaUtils.loadJavaType((String)this.javaTypeName, (ClassLoader)loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return wrapperBean;
    }

    public Class getJavaType() {
        Class tmpJavaType = this.javaType;
        if (tmpJavaType == null && this.javaTypeName != null) {
            try {
                ClassLoader loader = this.getClassLoader();
                tmpJavaType = JavaUtils.loadJavaType((String)this.javaTypeName, (ClassLoader)loader);
                UnifiedMetaData wsMetaData = this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData();
                if (wsMetaData.isEagerInitialized()) {
                    this.javaType = tmpJavaType;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new WSException("Cannot load java type: " + this.javaTypeName, ex);
            }
        }
        return tmpJavaType;
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        if ("IN".equals(mode)) {
            this.setMode(ParameterMode.IN);
        } else if ("INOUT".equals(mode)) {
            this.setMode(ParameterMode.INOUT);
        } else if ("OUT".equals(mode)) {
            this.setMode(ParameterMode.OUT);
        } else {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
    }

    public void setMode(ParameterMode mode) {
        this.mode = mode;
    }

    public Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(String mimeStr) {
        this.mimeTypes = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(mimeStr, ",");
        while (st.hasMoreTokens()) {
            this.mimeTypes.add(st.nextToken().trim());
        }
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setInHeader(boolean inHeader) {
        this.inHeader = inHeader;
    }

    public boolean isSwA() {
        return this.isSwA;
    }

    public void setSwA(boolean isSwA) {
        this.isSwA = isSwA;
    }

    public boolean isSwaRef() {
        return this.isSwaRef;
    }

    public void setSwaRef(boolean swaRef) {
        this.isSwaRef = swaRef;
    }

    public boolean isXOP() {
        return this.isXOP;
    }

    public void setXOP(boolean isXOP) {
        this.isXOP = isXOP;
    }

    public boolean isSOAPArrayParam() {
        return this.soapArrayParam;
    }

    public void setSOAPArrayParam(boolean soapArrayParam) {
        this.soapArrayParam = soapArrayParam;
    }

    public QName getSOAPArrayCompType() {
        return this.soapArrayCompType;
    }

    public void setSOAPArrayCompType(QName compXmlType) {
        if (compXmlType != null && !compXmlType.equals(this.soapArrayCompType)) {
            String logmsg = "SOAPArrayCompType: [xmlType=" + this.xmlType + ",compType=" + compXmlType + "]";
            this.log.debug((Object)((this.soapArrayCompType == null ? "set" : "reset") + logmsg));
        }
        this.soapArrayCompType = compXmlType;
    }

    @Deprecated
    public boolean isMessageType() {
        return messageTypes.contains(this.javaTypeName);
    }

    @Deprecated
    public static boolean isMessageType(String javaTypeName) {
        return messageTypes.contains(javaTypeName);
    }

    private String convertXmlTypeToMimeType(QName xmlType) {
        StringBuilder mimeName = new StringBuilder(xmlType.getLocalPart());
        int pos = mimeName.indexOf("_");
        if (pos == -1) {
            throw new IllegalArgumentException("Invalid mime type: " + xmlType);
        }
        mimeName.setCharAt(pos, '/');
        return mimeName.toString();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<WrappedParameter> getWrappedParameters() {
        return this.wrappedParameters;
    }

    public void setWrappedParameters(List<WrappedParameter> wrappedParameters) {
        this.wrappedParameters = wrappedParameters;
    }

    public String getPartName() {
        String auxPartName = this.partName;
        if (this.opMetaData.getEndpointMetaData().getConfig().hasFeature("http://org.jboss.ws/binding/wsdl/dotnet") && this.opMetaData.isDocumentWrapped() && !this.inHeader) {
            auxPartName = "parameters";
        }
        return auxPartName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public void validate() {
    }

    public void eagerInitialize() {
        this.javaType = null;
        EndpointMetaData.Type epType = this.getOperationMetaData().getEndpointMetaData().getType();
        if (this.getOperationMetaData().isDocumentWrapped() && !this.isInHeader() && !this.isSwA() && !this.isMessageType()) {
            if (this.loadWrapperBean() == null) {
                if (epType == EndpointMetaData.Type.JAXRPC) {
                    throw new WSException("Autogeneration of wrapper beans not supported with JAXRPC");
                }
                new DynamicWrapperGenerator(this.getClassLoader()).generate(this);
            }
            AccessorFactory factory = this.accessorFactoryCreator.create(this);
            for (WrappedParameter wrapped : this.wrappedParameters) {
                wrapped.setAccessor(factory.create(wrapped));
            }
        }
        this.javaType = this.getJavaType();
        if (this.javaType == null) {
            throw new WSException("Cannot load java type: " + this.javaTypeName);
        }
        this.initializeAttachmentParameter(epType);
    }

    private void initializeAttachmentParameter(EndpointMetaData.Type epType) {
        ReflectiveAttachmentRefScanner scanner;
        AttachmentScanResult scanResult;
        if (epType == EndpointMetaData.Type.JAXWS && (scanResult = (scanner = new ReflectiveAttachmentRefScanner()).scanBean(this.javaType)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Identified attachment reference: " + this.xmlName + ", type=" + (Object)((Object)scanResult.getType())));
            }
            if (scanResult.getType() == AttachmentScanResult.Type.XOP) {
                this.setXOP(true);
            } else {
                this.setSwaRef(true);
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
        if (loader == null) {
            throw new WSException("ClassLoader not available");
        }
        return loader;
    }

    public boolean matchParameter(Method method, Set<Integer> matches, boolean exact) {
        ClassLoader loader = this.getOperationMetaData().getEndpointMetaData().getClassLoader();
        List<WrappedParameter> wrappedParameters = this.getWrappedParameters();
        Class wrapperType = this.getJavaType();
        if (wrappedParameters == null) {
            return ParameterMetaData.matchParameter(method, this.getIndex(), this.getJavaType(), matches, exact, this.mode != ParameterMode.IN);
        }
        for (WrappedParameter wrapped : wrappedParameters) {
            String typeName = wrapped.getType();
            try {
                Class type;
                Class clazz = type = typeName != null ? JavaUtils.loadJavaType((String)typeName, (ClassLoader)loader) : ParameterWrapping.getWrappedType(wrapped.getVariable(), wrapperType);
                if (type == null) {
                    return false;
                }
                if (ParameterMetaData.matchParameter(method, wrapped.getIndex(), type, matches, exact, wrapped.isHolder())) continue;
                return false;
            }
            catch (Exception ex) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Invalid wrapper type:" + typeName), (Throwable)ex);
                }
                return false;
            }
        }
        return true;
    }

    public void setAccessorFactoryCreator(AccessorFactoryCreator accessorFactoryCreator) {
        this.accessorFactoryCreator = accessorFactoryCreator;
    }

    public String toString() {
        boolean isReturn = this.opMetaData.getReturnParameter() == this;
        StringBuilder buffer = new StringBuilder("\n" + (isReturn ? "ReturnMetaData:" : "ParameterMetaData:"));
        buffer.append("\n xmlName=" + this.getXmlName());
        buffer.append("\n partName=" + this.getPartName());
        buffer.append("\n xmlType=" + this.getXmlType());
        if (this.soapArrayParam) {
            buffer.append("\n soapArrayCompType=" + this.soapArrayCompType);
        }
        buffer.append("\n javaType=" + this.getJavaTypeName());
        buffer.append("\n mode=" + this.getMode());
        buffer.append("\n inHeader=" + this.isInHeader());
        buffer.append("\n index=" + this.index);
        if (this.isSwA()) {
            buffer.append("\n isSwA=" + this.isSwA());
            buffer.append("\n mimeTypes=" + this.getMimeTypes());
        }
        if (this.isXOP()) {
            buffer.append("\n isXOP=" + this.isXOP());
            buffer.append("\n mimeTypes=" + this.getMimeTypes());
        }
        if (this.wrappedParameters != null) {
            buffer.append("\n wrappedParameters=" + this.wrappedParameters);
        }
        return buffer.toString();
    }

    static {
        messageTypes.add("javax.xml.soap.SOAPElement");
        messageTypes.add("org.w3c.dom.Element");
    }
}

