/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.JobRunShell;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.SchedulingContext;
import org.quartz.ee.jta.UserTransactionHelper;

public class JTAJobRunShell
extends JobRunShell {
    private UserTransaction ut;
    private UserTransactionHelper userTxHelper;

    public JTAJobRunShell(JobRunShellFactory jobRunShellFactory, Scheduler scheduler, SchedulingContext schdCtxt, UserTransactionHelper userTxHelper) {
        super(jobRunShellFactory, scheduler, schdCtxt);
        this.userTxHelper = userTxHelper;
    }

    protected void begin() throws SchedulerException {
        try {
            this.ut = this.userTxHelper.lookup();
            this.ut.begin();
        }
        catch (SchedulerException se) {
            throw se;
        }
        catch (Exception nse) {
            throw new SchedulerException("JTAJobRunShell could not start UserTransaction.", nse);
        }
    }

    protected void complete(boolean successfulExecution) throws SchedulerException {
        if (this.ut == null) {
            return;
        }
        try {
            if (this.ut.getStatus() == 1) {
                successfulExecution = false;
            }
        }
        catch (SystemException e) {
            throw new SchedulerException("JTAJobRunShell could not read UserTransaction status.", (Exception)((Object)e));
        }
        if (successfulExecution) {
            try {
                this.ut.commit();
            }
            catch (Exception nse) {
                throw new SchedulerException("JTAJobRunShell could not commit UserTransaction.", nse);
            }
        }
        try {
            this.ut.rollback();
        }
        catch (Exception nse) {
            throw new SchedulerException("JTAJobRunShell could not rollback UserTransaction.", nse);
        }
        this.ut = null;
    }
}

