/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.console.manager.PluginManagerMBean;
import org.jboss.console.manager.interfaces.ConsolePlugin;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeInfo;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.DefaultTreeInfo;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.manager.interfaces.impl.MBeanAction;
import org.jboss.console.manager.interfaces.impl.MBeanResource;
import org.jboss.console.manager.interfaces.impl.SeparatorTreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNodeMenuEntryImpl;
import org.jboss.console.navtree.RefreshTreeAction;
import org.jboss.jmx.adaptor.rmi.RMIRemoteMBeanProxy;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.Util;

public class PluginManager
extends ServiceMBeanSupport
implements PluginManagerMBean,
NotificationListener {
    public static String PLUGIN_MANAGER_NAME = null;
    protected ArrayList plugins = new ArrayList();
    protected ManageableResource bootstrapResource = null;
    public String jndiName = "console/PluginManager";
    protected long treeVersion = 0L;
    protected HashMap currentTrees = new HashMap();
    protected String mainLogoUrl = "/web-console/images/jboss.gif";
    protected String mainLinkUrl = "http://www.jboss.org/forums/";
    protected boolean enableShutdown = true;

    public void createService() throws Exception {
        this.bootstrapResource = new MBeanResource(this.getServiceName(), this.getClass().toString());
    }

    public void startService() throws Exception {
        this.bindProxyInJndi();
        PLUGIN_MANAGER_NAME = this.getServiceName().toString();
        Registry.bind((Object)PLUGIN_MANAGER_NAME, (Object)this);
        this.initNotificationReception();
    }

    public void stopService() {
        Registry.unbind((Object)this.getServiceName().toString());
    }

    public void registerPlugin(String consolePluginClassName) throws Exception {
        Class<?> pluginClass = Thread.currentThread().getContextClassLoader().loadClass(consolePluginClassName);
        ConsolePlugin plugin = (ConsolePlugin)pluginClass.newInstance();
        this.registerPlugin(plugin);
    }

    public synchronized void registerPlugin(ConsolePlugin plugin) {
        this.plugins.add(plugin);
        this.regenerateAdminTree();
    }

    public synchronized void unregisterPlugin(ConsolePlugin plugin) {
        this.plugins.remove(plugin);
        this.regenerateAdminTree();
    }

    public synchronized void regenerateAdminTree() {
        this.currentTrees.clear();
    }

    public synchronized void regenerateAdminTreeForProfile(String profile) {
        this.currentTrees.remove(profile);
    }

    public synchronized TreeInfo getTreeForProfile(String profile) {
        TreeInfo currentTree = (TreeInfo)this.currentTrees.get(profile);
        if (currentTree == null) {
            HashSet<ManageableResource> resourcesToManage = new HashSet<ManageableResource>();
            DefaultTreeInfo result = new DefaultTreeInfo();
            ArrayList pluginsSubset = this.getPluginsSubsetForProfile(profile);
            HashSet<ManageableResource> resourcesAlreadyScanned = new HashSet<ManageableResource>();
            result.setRootResources(new ManageableResource[]{this.bootstrapResource});
            resourcesToManage.add(this.bootstrapResource);
            while (resourcesToManage.size() > 0) {
                ManageableResource currentResource = (ManageableResource)resourcesToManage.iterator().next();
                resourcesToManage.remove(currentResource);
                resourcesAlreadyScanned.add(currentResource);
                Iterator iter = this.getTreesForResource(currentResource, profile, pluginsSubset);
                while (iter.hasNext()) {
                    TreeNode subTree = (TreeNode)iter.next();
                    result.addTreeToResource(currentResource, subTree);
                    HashSet subResources = this.findSubResources(subTree);
                    if (subResources == null || subResources.size() <= 0) continue;
                    for (ManageableResource subRes : subResources) {
                        if (resourcesAlreadyScanned.contains(subRes)) continue;
                        resourcesToManage.add(subRes);
                    }
                }
            }
            ++this.treeVersion;
            result.setTreeVersion(this.treeVersion);
            try {
                TreeNodeMenuEntry[] base = new TreeNodeMenuEntry[]{new SimpleTreeNodeMenuEntryImpl("Update tree", new RefreshTreeAction(false)), new SimpleTreeNodeMenuEntryImpl("Force update tree", new RefreshTreeAction(true))};
                if (this.enableShutdown) {
                    result.setRootMenus(new TreeNodeMenuEntry[]{base[0], base[1], new SeparatorTreeNodeMenuEntry(), new SimpleTreeNodeMenuEntryImpl("Shutdown JBoss instance", new MBeanAction(new ObjectName("jboss.system:type=Server"), "shutdown", new Object[0], new String[0])), new SimpleTreeNodeMenuEntryImpl("Shutdown and Restart JBoss instance", new MBeanAction(new ObjectName("jboss.system:type=Server"), "exit", new Object[]{new Integer(10)}, new String[]{"int"})), new SimpleTreeNodeMenuEntryImpl("HALT and Restart JBoss instance", new MBeanAction(new ObjectName("jboss.system:type=Server"), "halt", new Object[]{new Integer(10)}, new String[]{"int"}))});
                } else {
                    result.setRootMenus(base);
                }
                result.setHomeAction(new HttpLinkTreeAction(this.mainLinkUrl));
                result.setIconUrl(this.mainLogoUrl);
            }
            catch (Exception bla) {
                // empty catch block
            }
            currentTree = result;
            this.currentTrees.put(profile, currentTree);
        }
        return currentTree;
    }

    public synchronized TreeInfo getUpdateTreeForProfile(String profile, long knownVersion) {
        TreeInfo currentTree = (TreeInfo)this.currentTrees.get(profile);
        if (this.treeVersion > knownVersion || currentTree == null) {
            return this.getTreeForProfile(profile);
        }
        return null;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public ManageableResource getBootstrapResource() {
        return this.bootstrapResource;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public boolean isEnableShutdown() {
        return this.enableShutdown;
    }

    public void setEnableShutdown(boolean enableShutdown) {
        this.enableShutdown = enableShutdown;
        ++this.treeVersion;
    }

    public String getMainLinkUrl() {
        return this.mainLinkUrl;
    }

    public void setMainLinkUrl(String mainLinkUrl) {
        this.mainLinkUrl = mainLinkUrl;
        ++this.treeVersion;
    }

    public String getMainLogoUrl() {
        return this.mainLogoUrl;
    }

    public void setMainLogoUrl(String mainLogoUrl) {
        this.mainLogoUrl = mainLogoUrl;
        ++this.treeVersion;
    }

    public void handleNotification(Notification notif, Object handback) {
        this.regenerateAdminTree();
    }

    protected Iterator getTreesForResource(ManageableResource res, String profile, ArrayList pluginsSubset) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (int i = 0; i < pluginsSubset.size(); ++i) {
            ConsolePlugin cp = (ConsolePlugin)pluginsSubset.get(i);
            TreeNode node = null;
            try {
                node = cp.getSubTreeForResource(this, profile, res);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (node == null) continue;
            result.add(node);
        }
        return result.iterator();
    }

    protected ArrayList getPluginsSubsetForProfile(String profile) {
        ArrayList<ConsolePlugin> result = new ArrayList<ConsolePlugin>();
        for (int i = 0; i < this.plugins.size(); ++i) {
            ConsolePlugin cp = (ConsolePlugin)this.plugins.get(i);
            String[] set = cp.getSupportedProfiles();
            if (!Arrays.asList(set).contains(profile)) continue;
            result.add(cp);
        }
        return result;
    }

    protected HashSet findSubResources(TreeNode tree) {
        TreeNode[] ns;
        ResourceTreeNode[] rns;
        HashSet<ManageableResource> result = new HashSet<ManageableResource>();
        if (tree instanceof ResourceTreeNode) {
            result.add(((ResourceTreeNode)tree).getResource());
        }
        if ((rns = tree.getNodeManagableResources()) != null && rns.length > 0) {
            for (int i = 0; i < rns.length; ++i) {
                result.add(rns[i].getResource());
                HashSet subResult = this.findSubResources(rns[i]);
                if (subResult == null || subResult.size() <= 0) continue;
                result.addAll(subResult);
            }
        }
        if ((ns = tree.getSubNodes()) != null && ns.length > 0) {
            for (int i = 0; i < ns.length; ++i) {
                HashSet subResult = this.findSubResources(ns[i]);
                if (subResult == null || subResult.size() <= 0) continue;
                result.addAll(subResult);
            }
        }
        return result;
    }

    protected void bindProxyInJndi() throws Exception {
        InitialContext ctx = new InitialContext();
        Object proxy = RMIRemoteMBeanProxy.create(PluginManagerMBean.class, (ObjectName)this.getServiceName(), (MBeanServer)this.getServer());
        Util.rebind((Context)ctx, (String)this.jndiName, (Object)proxy);
    }

    protected void initNotificationReception() throws Exception {
        ObjectName mbsDelegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        NotificationFilter filter = new NotificationFilter(){

            public boolean isNotificationEnabled(Notification n) {
                return n.getType().equals("JMX.mbean.registered") || n.getType().equals("JMX.mbean.unregistered");
            }
        };
        this.getServer().addNotificationListener(mbsDelegate, this, filter, null);
    }
}

