/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.versioned.CollectionStateManager;
import org.jboss.aspects.versioned.DistributedListUpdate;
import org.jboss.aspects.versioned.DistributedState;
import org.jboss.aspects.versioned.DistributedUpdate;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.OptimisticLockFailure;
import org.jboss.aspects.versioned.SynchronizationManager;
import org.jboss.aspects.versioned.VersionManager;
import org.jboss.aspects.versioned.VersionReference;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.util.id.GUID;

public class DistributedListState
extends CollectionStateManager
implements List,
DistributedState,
Externalizable {
    private static final long serialVersionUID = 8318313674571329182L;
    private static HashMap listMethodMap;
    protected static Logger log;
    protected volatile long versionId;
    protected ArrayList updates;
    protected String classname;
    protected transient List base;
    protected transient TransactionLocal txState = new TransactionLocal();
    protected transient TransactionLocal txVersion = new TransactionLocal();
    protected transient DistributedVersionManager versionManager;
    protected transient SynchronizationManager synchManager;
    protected transient TransactionManager tm;
    protected transient ClassProxy proxy;

    public DistributedListState() {
    }

    public DistributedListState(GUID guid, long timeout, ClassProxy proxy, List obj, DistributedVersionManager versionManager, SynchronizationManager synchManager) throws Exception {
        super(guid, timeout, listMethodMap);
        this.base = obj;
        this.classname = obj.getClass().getName();
        this.versionManager = versionManager;
        this.synchManager = synchManager;
        this.proxy = proxy;
        InitialContext ctx = new InitialContext();
        this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        this.updates = this.createListUpdates(this.base);
    }

    public HashMap getMethodMap() {
        return ClassProxyFactory.getMethodMap((String)this.base.getClass().getName());
    }

    public InstanceAdvised getObject() {
        return this.proxy;
    }

    protected List getCurrentState(boolean forUpdate) throws Exception {
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            if (forUpdate) {
                ++this.versionId;
            }
            return this.base;
        }
        List state = (List)this.txState.get(tx);
        if (state == null && forUpdate) {
            state = (List)this.base.getClass().newInstance();
            state.addAll(this.base);
            this.txState.set(tx, (Object)state);
            long newId = this.versionId + 1L;
            this.synchManager.registerUpdate(tx, this);
            this.txVersion.set(tx, (Object)new Long(newId));
            return state;
        }
        return this.base;
    }

    protected ArrayList createListUpdates(List state) {
        ArrayList<VersionReference> listUpdates = new ArrayList<VersionReference>(state.size());
        Iterator it = state.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (this.versionManager.isVersioned(obj)) {
                listUpdates.add(new VersionReference(VersionManager.getGUID((InstanceAdvised)obj)));
                continue;
            }
            listUpdates.add((VersionReference)obj);
        }
        return listUpdates;
    }

    public DistributedUpdate createTxUpdate(Transaction tx) {
        List state = (List)this.txState.get(tx);
        long newId = (Long)this.txVersion.get(tx);
        DistributedListUpdate update = new DistributedListUpdate(this.guid, this.createListUpdates(state), newId);
        return update;
    }

    public InstanceAdvised buildObject(SynchronizationManager manager, DistributedVersionManager versionManager) throws Exception {
        log.trace((Object)"building a List");
        this.versionManager = versionManager;
        this.synchManager = manager;
        log.trace((Object)("DistributedListState: classname: " + this.classname));
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.classname);
        this.base = (List)clazz.newInstance();
        Iterator it = this.updates.iterator();
        while (it.hasNext()) {
            VersionReference ref;
            Object val = it.next();
            if (val instanceof VersionReference && (val = manager.getObject((ref = (VersionReference)val).getGUID())) == null) {
                DistributedState fieldVal = manager.getState(ref.getGUID());
                val = fieldVal.buildObject(manager, versionManager);
                ref.set((InstanceAdvised)val);
            }
            this.base.add(val);
        }
        this.proxy = versionManager.addListVersioning(this.base, this);
        return this.proxy;
    }

    public void checkOptimisticLock(Transaction tx) {
        Long version = (Long)this.txVersion.get(tx);
        if (version <= this.versionId) {
            throw new OptimisticLockFailure("optimistic lock failure for list");
        }
    }

    public void mergeState(Transaction tx) throws Exception {
        List current;
        this.base = current = (List)this.txState.get(tx);
        Long version = (Long)this.txVersion.get(tx);
        this.versionId = version;
    }

    public void mergeState(DistributedUpdate update) throws Exception {
        DistributedListUpdate listUpdate = (DistributedListUpdate)update;
        this.versionId = listUpdate.versionId;
        this.base.clear();
        Iterator it = listUpdate.listUpdates.iterator();
        while (it.hasNext()) {
            Object val = it.next();
            if (val instanceof VersionReference) {
                VersionReference ref = (VersionReference)val;
                val = this.synchManager.getObject(ref.getGUID());
                ref.set((InstanceAdvised)val);
            }
            this.base.add(val);
        }
        this.updates = listUpdate.listUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object val) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            val = this.versionManager.makeVersioned(val);
            List state = this.getCurrentState(true);
            bl = state.add(val);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object val) {
        try {
            this.lock.readLock().acquire();
            try {
                val = this.versionManager.makeVersioned(val);
                List state = this.getCurrentState(true);
                state.add(index, val);
            }
            finally {
                this.lock.readLock().release();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(true);
            Object[] copy = c.toArray();
            for (int i = 0; i < copy.length; ++i) {
                Object item = this.versionManager.makeVersioned(copy[i]);
                state.add(item);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(true);
            Object[] copy = c.toArray();
            for (int i = 0; i < copy.length; ++i) {
                Object item = this.versionManager.makeVersioned(copy[i]);
                state.add(index + i, item);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.lock.readLock().acquire();
            try {
                List state = this.getCurrentState(true);
                state.clear();
            }
            finally {
                this.lock.readLock().release();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            bl = state.contains(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            bl = state.containsAll(c);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            bl = ((Object)state).equals(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int i) {
        Object e;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            e = state.get(i);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            n = ((Object)state).hashCode();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        int n;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            n = state.indexOf(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            bl = state.isEmpty();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        Iterator iterator;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            iterator = state.iterator();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        int n;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            n = state.lastIndexOf(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        ListIterator listIterator;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            listIterator = state.listIterator();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return listIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int index) {
        ListIterator listIterator;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            listIterator = state.listIterator(index);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return listIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        Object e;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(true);
            e = state.remove(index);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(true);
            bl = state.remove(o);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(true);
            bl = state.removeAll(c);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        boolean bl;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(true);
            bl = state.retainAll(c);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        Object object;
        this.lock.readLock().acquire();
        try {
            try {
                element = this.versionManager.makeVersioned(element);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            List state = this.getCurrentState(true);
            object = state.set(index, element);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            n = state.size();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int fromIndex, int toIndex) {
        List list;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            list = state.subList(fromIndex, toIndex);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object[] objectArray;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            objectArray = state.toArray();
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        Object[] objectArray;
        this.lock.readLock().acquire();
        try {
            List state = this.getCurrentState(false);
            objectArray = state.toArray(a);
        }
        catch (Throwable throwable) {
            try {
                this.lock.readLock().release();
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.lock.readLock().release();
        return objectArray;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.versionId);
        out.writeObject(this.updates);
        out.writeObject(this.classname);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.versionId = in.readLong();
        this.updates = (ArrayList)in.readObject();
        this.classname = (String)in.readObject();
        try {
            InitialContext ctx = new InitialContext();
            this.tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.txState = new TransactionLocal();
        this.txVersion = new TransactionLocal();
        this.methodMap = listMethodMap;
    }

    static {
        log = Logger.getLogger((Class)DistributedListState.class);
        try {
            listMethodMap = new HashMap();
            Method[] methods = List.class.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                long hash = MethodHashing.methodHash((Method)methods[i]);
                listMethodMap.put(new Long(hash), methods[i]);
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }
}

