/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperThread;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class TransactionReaper {
    public static final String NORMAL = "NORMAL";
    public static final String DYNAMIC = "DYNAMIC";
    public static final long defaultCheckPeriod = 120000L;
    private SortedSet _transactions = Collections.synchronizedSortedSet(new TreeSet());
    private Map _timeouts = Collections.synchronizedMap(new HashMap());
    private long _checkPeriod = 0L;
    private static TransactionReaper _theReaper = null;
    private static ReaperThread _reaperThread = null;
    private static boolean _dynamic = false;
    private static long _lifetime = 0L;

    public TransactionReaper(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 1L, "TransactionReaper::TransactionReaper ( " + checkPeriod + " )");
        }
        this._checkPeriod = checkPeriod;
        if (this._transactions == null) {
            if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.coordinator.TransactionReaper_1");
            }
            throw new OutOfMemoryError();
        }
    }

    public void finalize() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(2L, 4L, 1L, "TransactionReaper.finalize ()");
        }
        this._transactions = null;
    }

    public final long checkingPeriod() {
        if (_dynamic) {
            try {
                ReaperElement head = (ReaperElement)this._transactions.first();
                return head._absoluteTimeout - System.currentTimeMillis();
            }
            catch (NoSuchElementException nsee) {
                return Long.MAX_VALUE;
            }
        }
        return this._checkPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean check() {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::check ()");
        }
        while (true) {
            ReaperElement e;
            try {
                e = (ReaperElement)this._transactions.first();
            }
            catch (NoSuchElementException nsee) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (tsLogger.arjLoggerI18N.debugAllowed()) {
                tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_2", new Object[]{Long.toString(e._absoluteTimeout), Long.toString(now)});
            }
            if (now < e._absoluteTimeout) break;
            if (e._control.running()) {
                boolean problem = false;
                try {
                    if (e._control.cancel() == 4) {
                        if (tsLogger.arjLoggerI18N.debugAllowed()) {
                            tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[]{e._control.get_uid()});
                        }
                    } else {
                        problem = true;
                    }
                }
                catch (Exception ex2) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_4", new Object[]{e._control});
                    }
                    problem = true;
                }
                if (problem) {
                    boolean error = false;
                    boolean printDebug = tsLogger.arjLoggerI18N.isWarnEnabled();
                    try {
                        error = !e._control.preventCommit();
                    }
                    catch (Exception ex3) {
                        error = true;
                    }
                    if (error || printDebug) {
                        if (error) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_5", new Object[]{e._control});
                            }
                        } else if (tsLogger.arjLoggerI18N.debugAllowed()) {
                            tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[]{e._control});
                        }
                    }
                }
            }
            TransactionReaper transactionReaper = this;
            synchronized (transactionReaper) {
                this._timeouts.remove(e._control);
                this._transactions.remove(e);
            }
        }
        return true;
    }

    public final long numberOfTransactions() {
        return this._transactions.size();
    }

    public final long numberOfTimeouts() {
        return this._timeouts.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean insert(Reapable control, int timeout) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::insert ( " + control + ", " + timeout + " )");
        }
        if (timeout == 0) {
            return true;
        }
        if (this._timeouts.containsKey(control)) {
            return false;
        }
        ReaperElement e = new ReaperElement(control, timeout);
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            _lifetime += (long)timeout;
            this._timeouts.put(control, e);
            boolean rtn = this._transactions.add(e);
            if (_dynamic) {
                this.notify();
            }
            return rtn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(Object control) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::remove ( " + control + " )");
        }
        if (control == null) {
            return false;
        }
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            ReaperElement key = (ReaperElement)this._timeouts.remove(control);
            if (key == null) {
                return false;
            }
            return this._transactions.remove(key);
        }
    }

    public final int getTimeout(Object control) {
        if (this._transactions.size() == 0 || control == null) {
            if (tsLogger.arjLogger.debugAllowed()) {
                tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::getTimeout for " + control + " returning 0");
            }
            return 0;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        Integer timeout = reaperElement == null ? new Integer(0) : new Integer(reaperElement._timeout);
        tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.TransactionReaper_6", new Object[]{control, timeout});
        return timeout;
    }

    public static synchronized TransactionReaper create(long checkPeriod) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 1L, "TransactionReaper::create ( " + checkPeriod + " )");
        }
        if (_theReaper == null) {
            String mode = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperMode");
            if (mode != null && mode.compareTo(DYNAMIC) == 0) {
                _dynamic = true;
            }
            if (!_dynamic) {
                String timeoutEnv = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperTimeout");
                if (timeoutEnv != null) {
                    Long l = null;
                    try {
                        l = new Long(timeoutEnv);
                        checkPeriod = l;
                        l = null;
                    }
                    catch (NumberFormatException e) {
                        tsLogger.arjLogger.warn("TransactionReaper::create - " + e);
                    }
                }
            } else {
                checkPeriod = Long.MAX_VALUE;
            }
            _theReaper = new TransactionReaper(checkPeriod);
            _reaperThread = new ReaperThread(_theReaper);
            _reaperThread.setDaemon(true);
            _reaperThread.start();
        }
        return _theReaper;
    }

    public static TransactionReaper create() {
        return TransactionReaper.create(120000L);
    }

    public static TransactionReaper transactionReaper() {
        return TransactionReaper.transactionReaper(false);
    }

    public static synchronized TransactionReaper transactionReaper(boolean createReaper) {
        if (createReaper) {
            return TransactionReaper.create();
        }
        return _theReaper;
    }

    public static final synchronized long transactionLifetime() {
        return _lifetime;
    }

    static final void reset() {
        _theReaper = null;
    }
}

