/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociationActions;
import org.jboss.security.SimplePrincipal;

public class AltClientLoginModule
implements LoginModule {
    private static Logger log = Logger.getLogger(AltClientLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private boolean useFirstPass;
    private String username;
    private char[] password = null;
    private boolean trace;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String passwordStacking;
        String mt;
        this.trace = log.isTraceEnabled();
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        if (this.trace) {
            log.trace("Security domain: " + (String)options.get("jboss.security.security_domain"));
        }
        if (Boolean.valueOf(mt = (String)options.get("multi-threaded")).booleanValue()) {
            if (this.trace) {
                log.trace("Enabling multi-threaded mode");
            }
            SecurityAssociationActions.setServer();
        }
        boolean bl = this.useFirstPass = (passwordStacking = (String)options.get("password-stacking")) != null;
        if (this.trace && this.useFirstPass) {
            log.trace("Enabling useFirstPass mode");
        }
    }

    public boolean login() throws LoginException {
        if (this.useFirstPass) {
            return true;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        NameCallback nc = new NameCallback("User name: ", "guest");
        Callback[] callbacks = new Callback[]{nc, pc};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.password = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
                pc.clearPassword();
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        Principal p = null;
        Object credential = this.password;
        if (this.useFirstPass) {
            Object user = this.sharedState.get("javax.security.auth.login.name");
            if (!(user instanceof Principal)) {
                this.username = user != null ? user.toString() : "";
                p = new SimplePrincipal(this.username);
            } else {
                p = (Principal)user;
            }
            credential = this.sharedState.get("javax.security.auth.login.password");
        } else {
            p = new SimplePrincipal(this.username);
        }
        if (!principals.isEmpty()) {
            p = principals.iterator().next();
        }
        SecurityAssociationActions.setPrincipalInfo(p, credential, this.subject);
        return true;
    }

    public boolean abort() throws LoginException {
        int length = this.password != null ? this.password.length : 0;
        for (int n = 0; n < length; ++n) {
            this.password[n] = '\u0000';
        }
        SecurityAssociationActions.clear();
        return true;
    }

    public boolean logout() throws LoginException {
        SecurityAssociationActions.clear();
        return true;
    }
}

