/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.ejb.EJBException;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.EJBMetaDataImpl;
import org.jboss.ejb3.proxy.handle.HomeHandleImpl;
import org.jboss.ejb3.session.BaseSessionRemoteProxy;
import org.jboss.logging.Logger;

public abstract class BaseSessionProxyFactory
implements ProxyFactory,
Externalizable {
    private static final Logger log = Logger.getLogger(BaseSessionProxyFactory.class);
    private transient Container container;
    protected String containerGuid;
    protected String containerClusterUid;
    protected boolean isClustered = false;
    protected String jndiName;
    protected Class proxyClass;
    protected transient Constructor proxyConstructor;

    public Object createHomeProxy() {
        throw new RuntimeException("NYI");
    }

    public void setContainer(Container container) {
        this.container = container;
        this.containerGuid = Ejb3Registry.guid(container);
        this.containerClusterUid = Ejb3Registry.clusterUid(container);
        this.isClustered = container.isClustered();
    }

    protected Container getContainer() {
        if (this.container == null) {
            this.container = Ejb3Registry.findContainer(this.containerGuid);
            if (this.container == null && this.isClustered) {
                this.container = Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
        }
        return this.container;
    }

    protected void setEjb21Objects(BaseSessionRemoteProxy proxy) {
        proxy.setHandle(this.getHandle());
        proxy.setHomeHandle(this.getHomeHandle());
        proxy.setEjbMetaData(this.getEjbMetaData());
    }

    protected HomeHandle getHomeHandle() {
        EJBContainer ejbContainer = (EJBContainer)this.getContainer();
        HomeHandleImpl homeHandle = null;
        RemoteBinding remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class);
        if (remoteBindingAnnotation != null) {
            homeHandle = new HomeHandleImpl(ProxyFactoryHelper.getHomeJndiName((Container)this.getContainer()));
        }
        return homeHandle;
    }

    protected EJBMetaData getEjbMetaData() {
        RemoteBinding remoteBindingAnnotation;
        RemoteHome homeAnnotation;
        Class remote = null;
        Class home = null;
        Class<Object> pkClass = Object.class;
        HomeHandleImpl homeHandle = null;
        EJBContainer ejbContainer = (EJBContainer)this.getContainer();
        Remote remoteAnnotation = (Remote)ejbContainer.resolveAnnotation(Remote.class);
        if (remoteAnnotation != null) {
            remote = remoteAnnotation.value()[0];
        }
        if ((homeAnnotation = (RemoteHome)ejbContainer.resolveAnnotation(RemoteHome.class)) != null) {
            home = homeAnnotation.value();
        }
        if ((remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class)) != null) {
            homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
        }
        EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, homeHandle);
        return metadata;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerGuid = in.readUTF();
        this.containerClusterUid = in.readUTF();
        this.isClustered = in.readBoolean();
        this.jndiName = in.readUTF();
        this.proxyClass = (Class)in.readObject();
        try {
            if (this.getContainer() == null) {
                throw new EJBException("Invalid (i.e. remote) invocation of local interface (null container) for " + this.containerGuid);
            }
            Class[] interfaces = this.getInterfaces();
            Class<?> proxyClass = Proxy.getProxyClass(this.getContainer().getBeanClass().getClassLoader(), interfaces);
            Class[] constructorParams = new Class[]{InvocationHandler.class};
            this.proxyConstructor = proxyClass.getConstructor(constructorParams);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to read Externalized proxy " + e);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerGuid);
        out.writeUTF(this.containerClusterUid);
        out.writeBoolean(this.isClustered);
        out.writeUTF(this.jndiName);
        out.writeObject(this.proxyClass);
    }

    protected abstract Class[] getInterfaces();

    protected abstract Handle getHandle();
}

