/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.vm.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.vm.dao.VmOperationDetailDAO;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailBean;
import com.clustercontrol.vm.ejb.entity.VmOperationDetailPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VmOperationDetailDAOImpl
implements VmOperationDetailDAO {
    protected static Log m_log = LogFactory.getLog(VmOperationDetailDAOImpl.class);

    @Override
    public VmOperationDetailPK create(VmOperationDetailBean ejb) throws CreateException, EJBException {
        VmOperationDetailPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSessionId() + ", " + ejb.getFacilityId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_vm_operation_detail (");
            sql.append("session_id, ");
            sql.append("facility_id, ");
            sql.append("scope_text, ");
            sql.append("node_type, ");
            sql.append("command_id, ");
            sql.append("status, ");
            sql.append("start_date, ");
            sql.append("end_status, ");
            sql.append("end_date, ");
            sql.append("end_value, ");
            sql.append("message) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getSessionId());
            stmt.setString(2, ejb.getFacilityId());
            stmt.setString(3, ejb.getScopeText());
            stmt.setString(4, ejb.getNodeType());
            stmt.setString(5, ejb.getCommandId());
            if (ejb.getStatus() instanceof Short) {
                stmt.setShort(6, ejb.getStatus());
            } else {
                stmt.setNull(6, 5);
            }
            if (ejb.getStartDate() instanceof Date) {
                stmt.setTimestamp(7, new Timestamp(ejb.getStartDate().getTime()));
            } else {
                stmt.setTimestamp(7, null);
            }
            if (ejb.getEndStatus() instanceof Short) {
                stmt.setShort(8, ejb.getEndStatus());
            } else {
                stmt.setNull(8, 5);
            }
            if (ejb.getEndDate() instanceof Date) {
                stmt.setTimestamp(9, new Timestamp(ejb.getEndDate().getTime()));
            } else {
                stmt.setTimestamp(9, null);
            }
            if (ejb.getEndValue() instanceof Integer) {
                stmt.setInt(10, ejb.getEndValue());
            } else {
                stmt.setNull(10, 4);
            }
            stmt.setString(11, ejb.getMessage());
            int row = stmt.executeUpdate();
            pk = new VmOperationDetailPK(ejb.getSessionId(), ejb.getFacilityId());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getSessionId() + ", " + ejb.getFacilityId()));
        return pk;
    }

    @Override
    public ArrayList<VmOperationDetailPK> findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<VmOperationDetailPK> ret = new ArrayList<VmOperationDetailPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT session_id, facility_id FROM cc_vm_operation_detail";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                VmOperationDetailPK pk = new VmOperationDetailPK(res.getString("session_id"), res.getString("facility_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    @Override
    public VmOperationDetailPK findByPrimaryKey(VmOperationDetailPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT session_id, facility_id FROM cc_vm_operation_detail WHERE session_id = ? AND facility_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSessionId());
            stmt.setString(2, pk.getFacilityId());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            VmOperationDetailPK vmOperationDetailPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return vmOperationDetailPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<VmOperationDetailPK> findBySessionId(String sessionId) throws FinderException {
        m_log.debug((Object)("findBySessionId() start : " + sessionId));
        ArrayList<VmOperationDetailPK> ret = new ArrayList<VmOperationDetailPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT session_id,facility_id FROM cc_vm_operation_detail WHERE session_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, sessionId);
                res = stmt.executeQuery();
                while (res.next()) {
                    VmOperationDetailPK pk = new VmOperationDetailPK(res.getString("session_id"), res.getString("facility_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findBySessionId() end : " + sessionId));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<VmOperationDetailPK> findHistory(int history) throws FinderException {
        m_log.debug((Object)("findHistory() start : " + history));
        ArrayList<VmOperationDetailPK> ret = new ArrayList<VmOperationDetailPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT session_id,facility_id FROM cc_vm_operation_detail ORDER By start_date DESC LIMIT ?";
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, history);
                res = stmt.executeQuery();
                while (res.next()) {
                    VmOperationDetailPK pk = new VmOperationDetailPK(res.getString("session_id"), res.getString("facility_id"));
                    ret.add(pk);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("findHistory() end : " + history));
        return ret;
    }

    @Override
    public void init() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(VmOperationDetailPK pk, VmOperationDetailBean ejb) throws EJBException {
        m_log.debug((Object)("load() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_vm_operation_detail WHERE session_id = ? AND facility_id = ? ORDER BY start_date DESC, session_id, facility_id";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSessionId());
                stmt.setString(2, pk.getFacilityId());
                res = stmt.executeQuery();
                if (!res.next()) {
                    String msg = "VmOperationDetail data is not found.";
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                    throw new EJBException(msg);
                }
                ejb.setSessionId(res.getString("session_id"));
                ejb.setFacilityId(res.getString("facility_id"));
                ejb.setScopeText(res.getString("scope_text"));
                ejb.setNodeType(res.getString("node_type"));
                ejb.setCommandId(res.getString("command_id"));
                ejb.setStatus(res.getShort("status"));
                if (res.getTimestamp("start_date") != null) {
                    ejb.setStartDate(new Date(res.getTimestamp("start_date").getTime()));
                } else {
                    ejb.setStartDate(null);
                }
                ejb.setEndStatus(res.getShort("end_status"));
                if (res.getTimestamp("end_date") != null) {
                    ejb.setEndDate(new Date(res.getTimestamp("end_date").getTime()));
                } else {
                    ejb.setEndDate(null);
                }
                ejb.setEndValue(res.getInt("end_value"));
                ejb.setMessage(res.getString("message"));
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(VmOperationDetailPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_vm_operation_detail WHERE session_id = ? AND facility_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSessionId());
                stmt.setString(2, pk.getFacilityId());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void store(VmOperationDetailBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSessionId() + ", " + ejb.getFacilityId()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_vm_operation_detail SET ");
                sql.append("scope_text = ?, ");
                sql.append("node_type = ?, ");
                sql.append("command_id = ?, ");
                sql.append("status = ?, ");
                sql.append("start_date = ?, ");
                sql.append("end_status = ?, ");
                sql.append("end_date = ?, ");
                sql.append("end_value = ?, ");
                sql.append("message = ? ");
                sql.append("WHERE session_id = ? ");
                sql.append("AND facility_id = ?");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getScopeText());
                stmt.setString(2, ejb.getNodeType());
                stmt.setString(3, ejb.getCommandId());
                if (ejb.getStatus() instanceof Short) {
                    stmt.setShort(4, ejb.getStatus());
                } else {
                    stmt.setNull(4, 5);
                }
                if (ejb.getStartDate() instanceof Date) {
                    stmt.setTimestamp(5, new Timestamp(ejb.getStartDate().getTime()));
                } else {
                    stmt.setTimestamp(5, null);
                }
                if (ejb.getEndStatus() instanceof Short) {
                    stmt.setShort(6, ejb.getEndStatus());
                } else {
                    stmt.setNull(6, 5);
                }
                if (ejb.getEndDate() instanceof Date) {
                    stmt.setTimestamp(7, new Timestamp(ejb.getEndDate().getTime()));
                } else {
                    stmt.setTimestamp(7, null);
                }
                if (ejb.getEndValue() instanceof Integer) {
                    stmt.setInt(8, ejb.getEndValue());
                } else {
                    stmt.setNull(8, 4);
                }
                stmt.setString(9, ejb.getMessage());
                stmt.setString(10, ejb.getSessionId());
                stmt.setString(11, ejb.getFacilityId());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getSessionId() + ", " + ejb.getFacilityId() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getSessionId() + ", " + ejb.getFacilityId()));
    }
}

