/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import org.sblim.wbem.cim.UnsignedInt8;

public class UnsignedInt16
extends Number
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6300627291717069708L;
    private int iValue;
    public static int MIN_VALUE = 0;
    public static int MAX_VALUE = 65535;

    public UnsignedInt16(byte pValue) {
        if (pValue < MIN_VALUE || pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt16(short pValue) {
        if (pValue < MIN_VALUE || pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt16(int pValue) {
        if (pValue < MIN_VALUE || pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt16(String pValue) {
        if (pValue == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (pValue.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.iValue = Integer.parseInt(pValue);
        if (this.iValue < MIN_VALUE || this.iValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt16(UnsignedInt8 pValue) {
        this.iValue = pValue.intValue();
    }

    public UnsignedInt16(UnsignedInt16 pValue) {
        this.iValue = pValue.intValue();
    }

    public String toString() {
        return Integer.toString(this.iValue);
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt16) {
            return this.iValue == ((UnsignedInt16)o).iValue;
        }
        return false;
    }

    public byte byteValue() {
        if (this.iValue < -128 || this.iValue > 127) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return (byte)this.iValue;
    }

    public short shortValue() {
        if (this.iValue < Short.MIN_VALUE || this.iValue > Short.MAX_VALUE) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Short value which is inbetween " + Short.MIN_VALUE + " .. " + Short.MAX_VALUE);
        }
        return (short)this.iValue;
    }

    public int intValue() {
        return this.iValue;
    }

    public long longValue() {
        return this.iValue;
    }

    public float floatValue() {
        return this.iValue;
    }

    public double doubleValue() {
        return this.iValue;
    }

    public int hashCode() {
        return new Integer(this.iValue).hashCode();
    }

    public Object clone() {
        return new UnsignedInt16(this.iValue);
    }
}

