/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Vector;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMFlavor;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMQualifier
extends CIMElement
implements Cloneable {
    private static final long serialVersionUID = -8512859782330327384L;
    private CIMValue iValue = null;
    private boolean iPropagated = false;
    private Vector iFlavors = new Vector(0);
    private CIMQualifierType iType;

    public CIMQualifier() {
    }

    public CIMQualifier(String pName) {
        super(pName);
    }

    public CIMQualifier(String pName, CIMQualifierType pType) {
        super(pName);
        this.setDefaults(pType);
    }

    public void addFlavor(CIMFlavor pFlavor) {
        if (pFlavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        Utils.addSorted(this.iFlavors, pFlavor);
    }

    public Object clone() {
        CIMQualifier that = new CIMQualifier(this.iName);
        that.iPropagated = this.iPropagated;
        if (this.iType != null) {
            that.iType = (CIMQualifierType)this.iType.clone();
        }
        that.iFlavors = (Vector)this.iFlavors.clone();
        if (this.iValue != null) {
            that.iValue = (CIMValue)this.iValue.clone();
        }
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMQualifier)) {
            return false;
        }
        CIMQualifier that = (CIMQualifier)o;
        if (!(this.iValue != null ? this.iValue.equals(that.iValue) : that.iValue == null)) {
            return false;
        }
        if (!(this.iType != null ? this.iType.equals(that.iType) : that.iType == null)) {
            return false;
        }
        if (this.iPropagated != that.iPropagated || !this.iFlavors.equals(that.iFlavors)) {
            return false;
        }
        return this.iName.equalsIgnoreCase(that.iName);
    }

    public int hashCode() {
        return (this.iValue != null ? this.iValue.hashCode() : 0) << 16 + (this.iType != null ? this.iType.hashCode() : 0) << 8 + (this.iFlavors.hashCode() + (this.iPropagated ? 1 : 0)) + this.iName.toUpperCase().hashCode();
    }

    public Vector getFlavor() {
        return this.iFlavors;
    }

    public CIMValue getValue() {
        if (this.iValue == null && this.iType != null) {
            return this.iType.getDefaultValue();
        }
        return this.iValue;
    }

    public boolean hasFlavor(CIMFlavor pFlavor) {
        if (pFlavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        return Utils.hasValue(this.iFlavors, pFlavor);
    }

    public boolean hasValue() {
        return this.iValue != null;
    }

    public void setDefaults(CIMQualifierType pQualifierType) {
        if (pQualifierType == null) {
            throw new IllegalArgumentException("null qualifier type argument");
        }
        if (this.iValue == null && pQualifierType.hasDefaultValue()) {
            this.iValue = pQualifierType.getDefaultValue();
        }
        this.iFlavors = pQualifierType.getFlavor();
        this.iType = pQualifierType;
    }

    public void setValue(CIMValue pValue) {
        this.iValue = pValue;
    }

    public void setPropagated(boolean pValue) {
        this.iPropagated = pValue;
    }

    public boolean isPropagated() {
        return this.iPropagated;
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.iName);
        if (this.iValue != null && this.iValue.getType() != null && this.iValue.getType().isArrayType()) {
            buf.append(CIMElement.vectorToMOFString((Vector)this.iValue.getValue(), false, 0, 3, true));
        } else if (this.iValue != null) {
            buf.append(" ( ");
            buf.append(this.iValue);
            buf.append(" )");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMQualifier)) {
            throw new IllegalArgumentException("Invalid object to compare with");
        }
        return this.iName.toUpperCase().compareTo(((CIMQualifier)o).iName.toUpperCase());
    }
}

