/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.util.CharUtils;

public class CIMElement
implements Serializable,
Comparable {
    private static final long serialVersionUID = 8440203275058674221L;
    protected static final String[] OPENING_BRAKET = new String[]{"", "[", "(", "{"};
    protected static final String[] CLOSING_BRAKET = new String[]{"", "]", ")", "}"};
    protected static final String EMPTY = "";
    protected String iName;

    public CIMElement() {
        this.iName = EMPTY;
    }

    public CIMElement(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("null element name argument");
        }
        this.iName = pName;
    }

    public CIMElement(CIMElement pCimElement) {
        if (pCimElement == null) {
            throw new IllegalArgumentException("null element argument");
        }
        this.iName = pCimElement.iName;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("null element name argument");
        }
        this.iName = pName;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CIMElement)) {
            return false;
        }
        return this.iName.equalsIgnoreCase(((CIMElement)obj).iName);
    }

    public boolean lessThan(CIMElement pElement) {
        if (pElement == null) {
            throw new IllegalArgumentException("null element argument");
        }
        return this.iName.toUpperCase().compareTo(pElement.iName.toUpperCase()) < 0;
    }

    public CIMElement assign(CIMElement pNewElement) {
        if (pNewElement == null) {
            throw new IllegalArgumentException("null element argument");
        }
        this.iName = pNewElement.iName;
        return this;
    }

    protected static String vectorToMOFString(Vector pVector, boolean pLineFeed, int pSpacesPerTab) {
        return CIMElement.vectorToMOFString(pVector, pLineFeed, pSpacesPerTab, 1, true);
    }

    protected static String vectorToMOFString(Vector pVector) {
        return CIMElement.vectorToMOFString(pVector, true, 1, 1, true);
    }

    protected static void appendTab(StringBuffer pBuffer, int pSpacesPerTab) {
        while (pSpacesPerTab-- > 0) {
            pBuffer.append('\t');
        }
    }

    protected static String vectorToMOFString(Vector pVector, boolean pLineFeed, int pSpacesPerTab, int pBraketType, boolean pUseCommas) {
        StringBuffer buf = new StringBuffer();
        if (pVector != null) {
            CIMElement.appendTab(buf, pSpacesPerTab);
            buf.append(OPENING_BRAKET[pBraketType]);
            Iterator iter = pVector.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object o;
                if (i > 0) {
                    if (pUseCommas) {
                        buf.append(',');
                    }
                    if (pLineFeed) {
                        buf.append('\n');
                        CIMElement.appendTab(buf, pSpacesPerTab);
                    }
                    buf.append(' ');
                }
                if ((o = iter.next()) != null) {
                    if (o instanceof String || o instanceof CIMObjectPath) {
                        buf.append('\"' + CharUtils.escape(o.toString()) + '\"');
                    } else if (o instanceof Character) {
                        buf.append('\'' + CharUtils.escape(o.toString()) + '\'');
                    } else {
                        buf.append(o.toString());
                    }
                } else {
                    buf.append("NULL");
                }
                ++i;
            }
            if (pLineFeed) {
                buf.append('\n');
            }
            buf.append(CLOSING_BRAKET[pBraketType]);
        }
        return buf.toString();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMElement)) {
            throw new IllegalArgumentException("Invalid object to compare with");
        }
        return this.iName.compareToIgnoreCase(((CIMElement)o).iName);
    }
}

