/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionActivationListener;
import org.jboss.aspects.patterns.observable.Observer;
import org.jboss.aspects.patterns.observable.Subject;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.Util;

class FieldBasedClusteredSession
extends JBossCacheClusteredSession
implements Observer {
    private static final long serialVersionUID = 8347544395334247623L;
    protected static final String info = "FieldBasedClusteredSession/1.0";
    protected transient Map attributes_ = Collections.synchronizedMap(new HashMap());

    public FieldBasedClusteredSession(JBossCacheManager manager) {
        super(manager);
    }

    public void recycle() {
        super.recycle();
        this.attributes_.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FieldBasedClusteredSession[");
        sb.append(super.toString());
        sb.append("]");
        return sb.toString();
    }

    public void removeMyself() {
        this.proxy_.removeSession(this.realId);
    }

    public void removeMyselfLocal() {
        this.proxy_.removePojosLocal(this.realId);
        this.proxy_.removeSessionLocal(this.realId);
    }

    protected void populateAttributes() {
        Map excluded = FieldBasedClusteredSession.removeExcludedAttributes(this.attributes_);
        Set keys = this.proxy_.getPojoKeys(this.realId);
        HashSet oldKeys = new HashSet(this.attributes_.keySet());
        boolean hasListener = false;
        if (keys != null) {
            oldKeys.removeAll(keys);
            for (String name : keys) {
                Object oldAttrib = null;
                Object newAttrib = this.proxy_.getPojo(this.realId, name);
                if (newAttrib != null) {
                    oldAttrib = this.attributes_.put(name, newAttrib);
                    if (oldAttrib != newAttrib) {
                        this.proxy_.addObserver(this, newAttrib);
                        this.proxy_.removeObserver(this, oldAttrib);
                    }
                    if (!(newAttrib instanceof HttpSessionActivationListener)) continue;
                    hasListener = true;
                    continue;
                }
                oldAttrib = this.attributes_.remove(name);
                this.proxy_.removeObserver(this, oldAttrib);
            }
        }
        this.hasActivationListener = hasListener ? Boolean.TRUE : Boolean.FALSE;
        Iterator it = oldKeys.iterator();
        while (it.hasNext()) {
            Object oldAttrib = this.attributes_.remove(it.next());
            this.proxy_.removeObserver(this, oldAttrib);
        }
        if (excluded != null) {
            this.attributes.putAll(excluded);
        }
    }

    protected Object getJBossInternalAttribute(String name) {
        Object result = this.attributes_.get(name);
        if (this.isGetDirty(result)) {
            this.sessionAttributesDirty();
        }
        return result;
    }

    protected boolean isMutable(Object attribute) {
        boolean pojo = attribute instanceof Subject;
        boolean mutable = !pojo && super.isMutable(attribute);
        return mutable;
    }

    protected Object removeJBossInternalAttribute(String name, boolean localCall, boolean localOnly) {
        Object result;
        if (localCall && !replicationExcludes.contains(name)) {
            if (localOnly) {
                this.proxy_.removePojoLocal(this.realId, name);
            } else {
                this.proxy_.removePojo(this.realId, name);
            }
            this.sessionAttributesDirty();
        }
        if ((result = this.attributes_.remove(name)) == null) {
            log.warn((Object)("removeJBossInternalAttribute(): null value to remove with key: " + name));
            return null;
        }
        this.proxy_.removeObserver(this, result);
        return result;
    }

    protected Map getJBossInternalAttributes() {
        return this.attributes_;
    }

    protected Set getJBossInternalKeys() {
        return this.attributes_.keySet();
    }

    protected String[] keys() {
        return this.getJBossInternalKeys().toArray(EMPTY_ARRAY);
    }

    protected boolean canAttributeBeReplicated(Object attribute) {
        return Util.checkPojoType(attribute);
    }

    protected Object setJBossInternalAttribute(String key, Object value) {
        Object oldVal = null;
        if (!replicationExcludes.contains(key)) {
            oldVal = this.proxy_.setPojo(this.realId, key, value);
            if (oldVal != null) {
                this.proxy_.removeObserver(this, oldVal);
            }
            if (value != null) {
                if (value instanceof Map || value instanceof Collection) {
                    value = this.proxy_.getPojo(this.realId, key);
                }
                this.proxy_.addObserver(this, value);
            }
            this.sessionAttributesDirty();
        }
        oldVal = this.attributes_.put(key, value);
        return oldVal;
    }

    public void fireChange(Subject subject) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("fireChange(): subject has changed: " + subject));
        }
        this.sessionAttributesDirty();
    }
}

