/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.jboss.mx.loading.RepositoryClassLoader;

public class WebCtxLoader
implements Lifecycle,
Loader {
    protected ClassLoader encLoader;
    protected ENCLoader ctxLoader;
    protected RepositoryClassLoader delegate;
    protected Container webContainer;
    protected URL warURL;
    private ArrayList repositories = new ArrayList();

    WebCtxLoader(ClassLoader encLoader) {
        ClassLoader parent;
        this.encLoader = encLoader;
        this.ctxLoader = new ENCLoader(encLoader);
        for (parent = encLoader; !(parent instanceof RepositoryClassLoader) && parent != null; parent = parent.getParent()) {
        }
        this.delegate = (RepositoryClassLoader)parent;
    }

    public void setWarURL(URL warURL) throws MalformedURLException {
        File libDir;
        this.warURL = warURL;
        String path = warURL.getFile();
        File classesDir = new File(path, "WEB-INF/classes");
        if (classesDir.exists()) {
            this.delegate.addURL(classesDir.toURL());
            this.ctxLoader.addURLInternal(classesDir.toURL());
        }
        if ((libDir = new File(path, "WEB-INF/lib")).exists()) {
            File[] jars = libDir.listFiles();
            int length = jars != null ? jars.length : 0;
            for (int j = 0; j < length; ++j) {
                File jar = jars[j];
                if (!jar.getAbsolutePath().endsWith(".jar")) continue;
                this.delegate.addURL(jar.toURL());
                this.ctxLoader.addURLInternal(jar.toURL());
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() throws LifecycleException {
        if (this.ctxLoader == null) {
            throw new LifecycleException("WebCtxLoader cannot be restarted");
        }
        this.setClassPath();
        ServletContext servletContext = ((Context)this.webContainer).getServletContext();
        if (servletContext == null) {
            return;
        }
    }

    public void stop() throws LifecycleException {
        DirContextURLStreamHandler.unbind((ClassLoader)this.ctxLoader);
        LogFactory.release((ClassLoader)this.ctxLoader);
        LogFactory.release((ClassLoader)this.encLoader);
        this.encLoader = null;
        this.ctxLoader = null;
        this.delegate = null;
        this.repositories.clear();
        this.warURL = null;
        this.webContainer = null;
    }

    public void backgroundProcess() {
    }

    public ClassLoader getClassLoader() {
        return this.ctxLoader;
    }

    public Container getContainer() {
        return this.webContainer;
    }

    public void setContainer(Container container) {
        this.webContainer = container;
    }

    public boolean getDelegate() {
        return false;
    }

    public void setDelegate(boolean delegate) {
    }

    public String getInfo() {
        return null;
    }

    public boolean getReloadable() {
        return false;
    }

    public void setReloadable(boolean reloadable) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void addRepository(String repository) {
        if (this.repositories.contains(repository)) {
            return;
        }
        this.repositories.add(repository);
        this.setClassPath();
    }

    public String[] findRepositories() {
        String[] tmp = new String[this.repositories.size()];
        this.repositories.toArray(tmp);
        return tmp;
    }

    public boolean modified() {
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    private void setClassPath() {
        if (!(this.webContainer instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.webContainer).getServletContext();
        if (servletContext == null) {
            return;
        }
        try {
            Method method = this.webContainer.getClass().getMethod("getCompilerClasspath", null);
            Object baseClasspath = method.invoke((Object)this.webContainer, null);
            if (baseClasspath != null) {
                servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)baseClasspath.toString());
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < this.repositories.size(); ++i) {
            String repository = this.repositories.get(i).toString();
            if (repository.startsWith("file://")) {
                repository = repository.substring(7);
            } else if (repository.startsWith("file:")) {
                repository = repository.substring(5);
            } else {
                if (!repository.startsWith("jndi:")) continue;
                repository = servletContext.getRealPath(repository.substring(5));
            }
            if (repository == null) continue;
            if (i > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(repository);
        }
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath.toString());
    }

    static class ENCLoader
    extends URLClassLoader {
        private URL[] urllist = new URL[0];

        ENCLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        void addURLInternal(URL url) {
            URL[] result = new URL[this.urllist.length + 1];
            for (int i = 0; i < this.urllist.length; ++i) {
                result[i] = this.urllist[i];
            }
            result[this.urllist.length] = url;
            this.urllist = result;
        }

        public URL[] getURLs() {
            return this.urllist;
        }
    }
}

