/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.iiop.client;

import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.iiop.CorbaORB;
import org.jboss.tm.iiop.TransactionDesc;
import org.jboss.tm.iiop.TransactionFactoryExt;
import org.jboss.tm.iiop.TransactionFactoryExtHelper;
import org.jboss.tm.iiop.TxClientInterceptor;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Terminator;

public class IIOPClientUserTransaction
implements UserTransaction,
Referenceable,
Serializable {
    static final long serialVersionUID = 6653800687253055416L;
    private static IIOPClientUserTransaction singleton = null;
    private static TransactionFactoryExt txFactory;
    private static ThreadLocal threadLocalData;

    private static void setThreadLocalTimeout(int timeout) {
        ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).timeout = timeout;
    }

    private static int getThreadLocalTimeout() {
        return ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).timeout;
    }

    private static void setThreadLocalControl(Control control) {
        ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).control = control;
    }

    private static Control getThreadLocalControl() {
        return ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).control;
    }

    private static void setThreadLocalCoordinator(Coordinator coord) {
        ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).coord = coord;
    }

    private static Coordinator getThreadLocalCoordinator() {
        return ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).coord;
    }

    private static void setThreadLocalTerminator(Terminator term) {
        ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).term = term;
    }

    private static Terminator getThreadLocalTerminator() throws NoTransaction {
        Terminator term = ((TransactionInfo)IIOPClientUserTransaction.threadLocalData.get()).term;
        if (term == null) {
            throw new NoTransaction();
        }
        return term;
    }

    private static void setCurrentTransaction(Control control, PropagationContext pc) {
        IIOPClientUserTransaction.setThreadLocalControl(control);
        IIOPClientUserTransaction.setThreadLocalCoordinator(pc.current.coord);
        IIOPClientUserTransaction.setThreadLocalTerminator(pc.current.term);
        TxClientInterceptor.setOutgoingPropagationContext(pc);
    }

    private static void unsetCurrentTransaction() {
        IIOPClientUserTransaction.setThreadLocalControl(null);
        IIOPClientUserTransaction.setThreadLocalCoordinator(null);
        IIOPClientUserTransaction.setThreadLocalTerminator(null);
        TxClientInterceptor.unsetOutgoingPropagationContext();
    }

    private static TransactionFactoryExt getTxFactory() {
        if (txFactory == null) {
            try {
                ORB orb = CorbaORB.getInstance();
                Object obj = orb.resolve_initial_references("NameService");
                NamingContextExt rootContext = NamingContextExtHelper.narrow((Object)obj);
                Object txFactoryObj = rootContext.resolve_str("TransactionService");
                txFactory = TransactionFactoryExtHelper.narrow(txFactoryObj);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get transaction factory: " + e);
            }
        }
        return txFactory;
    }

    private static int cosTransactionsToJavax(Status status) {
        switch (status.value()) {
            case 0: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 8: {
                return 8;
            }
            case 1: {
                return 1;
            }
            case 6: {
                return 6;
            }
            case 2: {
                return 2;
            }
            case 7: {
                return 7;
            }
            case 4: {
                return 4;
            }
            case 9: {
                return 9;
            }
            case 5: {
                return 5;
            }
        }
        return 5;
    }

    private IIOPClientUserTransaction() {
    }

    public static IIOPClientUserTransaction getSingleton() {
        if (singleton == null) {
            singleton = new IIOPClientUserTransaction();
        }
        return singleton;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (IIOPClientUserTransaction.getThreadLocalControl() != null) {
            throw new NotSupportedException();
        }
        try {
            TransactionDesc td = IIOPClientUserTransaction.getTxFactory().create_transaction(IIOPClientUserTransaction.getThreadLocalTimeout());
            IIOPClientUserTransaction.setCurrentTransaction(td.control, td.propagationContext);
        }
        catch (RuntimeException e) {
            SystemException se = new SystemException("Failed to create tx");
            se.initCause((Throwable)e);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            IIOPClientUserTransaction.getThreadLocalTerminator().commit(true);
            IIOPClientUserTransaction.unsetCurrentTransaction();
        }
        catch (NoTransaction e) {
            IllegalStateException ex = new IllegalStateException();
            ex.initCause(e);
            throw ex;
        }
        catch (HeuristicMixed e) {
            HeuristicMixedException ex = new HeuristicMixedException();
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (HeuristicHazard e) {
            HeuristicRollbackException ex = new HeuristicRollbackException();
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (TRANSACTION_ROLLEDBACK e) {
            RollbackException ex = new RollbackException();
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (BAD_INV_ORDER e) {
            IllegalStateException ex = new IllegalStateException();
            ex.initCause(e);
            throw ex;
        }
        catch (NO_PERMISSION e) {
            SecurityException ex = new SecurityException();
            ex.initCause(e);
            throw ex;
        }
        catch (RuntimeException e) {
            SystemException ex = new SystemException();
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        try {
            IIOPClientUserTransaction.getThreadLocalTerminator().rollback();
            IIOPClientUserTransaction.unsetCurrentTransaction();
        }
        catch (NoTransaction e) {
            IllegalStateException ex = new IllegalStateException();
            ex.initCause(e);
            throw ex;
        }
        catch (BAD_INV_ORDER e) {
            IllegalStateException ex = new IllegalStateException();
            ex.initCause(e);
            throw ex;
        }
        catch (NO_PERMISSION e) {
            SecurityException ex = new SecurityException();
            ex.initCause(e);
            throw ex;
        }
        catch (RuntimeException e) {
            SystemException ex = new SystemException();
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Coordinator coord = IIOPClientUserTransaction.getThreadLocalCoordinator();
        if (coord == null) {
            throw new IllegalStateException();
        }
        try {
            coord.rollback_only();
        }
        catch (Inactive e) {
            SystemException ex = new SystemException();
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (BAD_INV_ORDER e) {
            IllegalStateException ex = new IllegalStateException();
            ex.initCause(e);
            throw ex;
        }
        catch (RuntimeException e) {
            SystemException ex = new SystemException();
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public int getStatus() throws SystemException {
        try {
            Coordinator coord = IIOPClientUserTransaction.getThreadLocalCoordinator();
            if (coord == null) {
                return 6;
            }
            return IIOPClientUserTransaction.cosTransactionsToJavax(coord.get_status());
        }
        catch (RuntimeException e) {
            SystemException ex = new SystemException();
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        IIOPClientUserTransaction.setThreadLocalTimeout(seconds);
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference("org.jboss.tm.iiop.client.IIOPClientUserTransaction", "org.jboss.tm.iiop.client.IIOPClientUserTransactionObjectFactory", null);
        return ref;
    }

    static {
        threadLocalData = new ThreadLocal(){

            protected synchronized java.lang.Object initialValue() {
                return new TransactionInfo();
            }
        };
    }

    private static class TransactionInfo {
        int timeout = 0;
        Control control;
        Coordinator coord;
        Terminator term;

        private TransactionInfo() {
        }
    }
}

