/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.interfaces.IProxyPushSupplier;

public class WaitRetryStrategy
extends AbstractRetryStrategy {
    public static final long WAIT_TIME_DEFAULT = 1000L;
    public static final long WAIT_INCREMENT_DEFAULT = 3000L;
    private long currentTimeToWait_;
    private long waitTimeIncrement_;

    public WaitRetryStrategy(IProxyPushSupplier iProxyPushSupplier, PushOperation pushOperation) {
        this(iProxyPushSupplier, pushOperation, 1000L, 3000L);
    }

    public WaitRetryStrategy(IProxyPushSupplier iProxyPushSupplier, PushOperation pushOperation, long l, long l2) {
        super(iProxyPushSupplier, pushOperation);
        this.currentTimeToWait_ = l;
        this.waitTimeIncrement_ = l2;
    }

    protected long getTimeToWait() {
        long l = this.currentTimeToWait_;
        this.currentTimeToWait_ += this.waitTimeIncrement_;
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void retryInternal() throws RetryException {
        while (true) {
            if (!this.isRetryAllowed()) throw new RetryException("no more retries possible");
            try {
                this.pushOperation_.invokePush();
                return;
            }
            catch (Exception exception) {
                this.remoteExceptionOccured(exception);
                continue;
            }
            break;
        }
        finally {
            this.dispose();
        }
    }
}

