/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.CreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.logging.Logger;

public class PkSqlCreateCommand
implements CreateCommand {
    private Logger log;
    private JDBCEntityBridge2 entityBridge;
    private String pkSql;
    private JDBCCMPFieldBridge2 pkField;

    public void init(JDBCStoreManager2 manager) throws DeploymentException {
        this.entityBridge = (JDBCEntityBridge2)manager.getEntityBridge();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.entityBridge.getEntityName()));
        JDBCFieldBridge[] pkFields = this.entityBridge.getPrimaryKeyFields();
        if (pkFields.length > 1) {
            throw new DeploymentException("This entity-command cannot be used with composite primary keys!");
        }
        this.pkField = (JDBCCMPFieldBridge2)pkFields[0];
        JDBCEntityCommandMetaData metadata = this.entityBridge.getMetaData().getEntityCommand();
        this.pkSql = metadata.getAttribute("pk-sql");
        if (this.pkSql == null) {
            throw new DeploymentException("pk-sql attribute must be set for entity " + this.entityBridge.getEntityName());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("entity-command generate pk sql: " + this.pkSql));
        }
    }

    public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx) throws CreateException {
        Object pk;
        block12: {
            PersistentContext pctx;
            block10: {
                pctx = (PersistentContext)ctx.getPersistenceContext();
                if (ctx.getId() != null) break block10;
                Connection con = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("executing sql: " + this.pkSql));
                    }
                    if (!(rs = (ps = (con = this.entityBridge.getDataSource().getConnection()).prepareStatement(this.pkSql)).executeQuery()).next()) {
                        throw new CreateException("pk-sql " + this.pkSql + " returned no results!");
                    }
                    pk = this.pkField.loadArgumentResults(rs, 1);
                    pctx.setFieldValue(this.pkField.getRowIndex(), pk);
                    pk = this.entityBridge.extractPrimaryKeyFromInstance(ctx);
                }
                catch (SQLException e) {
                    try {
                        this.log.error((Object)("Failed to execute pk sql. error code: " + e.getErrorCode() + ", sql state: " + e.getSQLState()), (Throwable)e);
                        throw new CreateException("Failed to execute pk sql: " + e.getMessage() + ", error code: " + e.getErrorCode() + ", sql state: " + e.getSQLState());
                    }
                    catch (Throwable throwable) {
                        JDBCUtil.safeClose(rs);
                        JDBCUtil.safeClose(ps);
                        JDBCUtil.safeClose(con);
                        throw throwable;
                    }
                }
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                if (pk == null) {
                    this.log.error((Object)"Primary key for created instance is null.");
                    throw new CreateException("Primary key for created instance is null.");
                }
                pctx.setPk(pk);
                break block12;
            }
            try {
                pctx.flush();
            }
            catch (SQLException e) {
                if ("23000".equals(e.getSQLState())) {
                    throw new DuplicateKeyException("Unique key violation or invalid foreign key value: pk=" + ctx.getId());
                }
                throw new CreateException("Failed to create instance: pk=" + ctx.getId() + ", state=" + e.getSQLState() + ", msg=" + e.getMessage());
            }
            pk = ctx.getId();
        }
        return pk;
    }
}

